using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Data;
using System.Text;
using System.Windows.Forms;
using System.Resources;
using System.Reflection;

namespace TestPanelFlyout
{
    [System.ComponentModel.DefaultEvent("ListHeaderStateChanged")]
    public partial class ListHeader : UserControl
    {
        private string _text;
        private bool isMinus = true;

        ResourceManager rm = null;

        public event ListHeaderStateChangedEventHandler ListHeaderStateChanged;

        public ListHeader()
        {
            InitializeComponent();

            rm = new ResourceManager(this.GetType());

            this.Paint += new PaintEventHandler(ListHeader_Paint);
        }

        // The text to display inside the control.
        [Browsable(true)]
        [DesignerSerializationVisibility(DesignerSerializationVisibility.Visible)]
        public override string Text
        {
            get
            {
                return (_text);
            }
            set
            {
                _text = value;
            }
        }

        // Paint in a custom gradient background, and render the text centered.
        void ListHeader_Paint(object sender, PaintEventArgs e)
        {
            LinearGradientBrush brush = new LinearGradientBrush(new Rectangle(0, 0, this.Width, this.Height), Color.FromArgb(219, 217, 200), Color.FromArgb(196, 193, 176), 90);
            e.Graphics.FillRectangle(brush, new Rectangle(0, 0, this.Width, this.Height));

            // Render the text next to the plus/minus box.
            int textOffsetX = pictureBox1.Location.X + pictureBox1.Width;
            RectangleF textRect = new RectangleF(textOffsetX + 4, 0, this.Width - textOffsetX, this.Height);
            StringFormat textFormat = new StringFormat();
            textFormat.Alignment = StringAlignment.Near;
            textFormat.LineAlignment = StringAlignment.Center;
            e.Graphics.DrawString(this.Text, this.Font, new SolidBrush(this.ForeColor), textRect, textFormat);
        }

        private void pictureBox1_Click(object sender, EventArgs e)
        {
            Image plusImage;

            if (isMinus)
            {
                plusImage = (Image)rm.GetObject("plusbox");
                isMinus = false;
                OnListHeaderStateChanged(new ListHeaderStateChangedEventArgs(ListHeaderState.Collapsed));
            }
            else
            {
                plusImage = (Image)rm.GetObject("pictureBox1.Image");
                isMinus = true;
                OnListHeaderStateChanged(new ListHeaderStateChangedEventArgs(ListHeaderState.Expanded));
            }

            pictureBox1.Image = plusImage;
        }

        protected virtual void OnListHeaderStateChanged(ListHeaderStateChangedEventArgs e)
        {
            if (ListHeaderStateChanged != null) ListHeaderStateChanged(this, e);
        }
    }

    public class ListHeaderStateChangedEventArgs : EventArgs
    {
        private ListHeaderState _state;

        public ListHeaderStateChangedEventArgs(ListHeaderState state) : base()
        {
            _state = state;
        }

        public ListHeaderState State
        {
            get
            {
                return (_state);
            }
        }
    }

    public enum ListHeaderState
    {
        Expanded = 0,
        Collapsed
    }

    public delegate void ListHeaderStateChangedEventHandler(object sender, ListHeaderStateChangedEventArgs e);
}