'---------------------------------------------------------------------
'  Copyright (C) Microsoft Corporation.  All rights reserved.

'THIS CODE AND INFORMATION ARE PROVIDED AS IS WITHOUT WARRANTY OF ANY
'KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
'IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
'PARTICULAR PURPOSE.
'---------------------------------------------------------------------

Imports System.Deployment.Application
Imports System.IO
Imports System.Xml
Imports WindowsForms = System.Windows.Forms

Namespace My

    ' The following events are availble for MyApplication:
    ' 
    ' Startup: Raised when the application starts, before the startup form is created.
    ' Shutdown: Raised after all application forms are closed.  This event is not raised if the application terminates abnormally.
    ' UnhandledException: Raised if the application encounters an unhandled exception.
    ' StartupNextInstance: Raised when launching a single-instance application and the application is already active. 
    ' NetworkAvailabilityChanged: Raised when the network connection is connected or disconnected.
    Partial Friend Class MyApplication
        Private _DataDirectory As String = Nothing
        Private _LogFileAvailable As Boolean = True
        Private _XmlDoc As XmlDocument = Nothing

        ' Check to see if we've created the countdown log before. If not, make a stub file.
        '  TODO: Test upgrade between ClickOnce versions - make sure our data is preserved!
        ' (It should be.)
        Private Sub MyApplication_Startup(ByVal sender As Object, ByVal e As Microsoft.VisualBasic.ApplicationServices.StartupEventArgs) Handles Me.Startup
            Dim _DataDir As String = DataDirectory
            If (Not File.Exists(_DataDir & "\log.xml")) Then
                Try
                    _XmlDoc = New XmlDocument()
                    Dim _Elem As XmlElement = _XmlDoc.CreateElement("Countdown")
                    _XmlDoc.AppendChild(_Elem)
                    Dim _ChildElem As XmlElement = _XmlDoc.CreateElement("Sessions")
                    _Elem.AppendChild(_ChildElem)

                    ' Persist to file.
                    WriteXmlFile()
                Catch ex As Exception
                    ' Don't bother the user with this - just report the error and warn the user later
                    ' that a log isn't available.
                    _LogFileAvailable = False
                End Try
            Else
                ' Load the log file for future usage.
                _XmlDoc = New XmlDocument()
                _XmlDoc.Load(_DataDir & "\log.xml")
            End If
        End Sub

        ' Let any exceptions bubble up. 
        Private Sub WriteXmlFile()
            Dim _Writer As XmlWriter = XmlWriter.Create(DataDirectory & "\log.xml")
            _XmlDoc.WriteTo(_Writer)
            _Writer.Close()
        End Sub

        Public ReadOnly Property DataDirectory() As String
            Get
                If (_DataDirectory Is Nothing) Then
                    _DataDirectory = GetDataDirectory()
                    DataDirectory = _DataDirectory
                Else
                    DataDirectory = _DataDirectory
                End If
            End Get
        End Property

        Public ReadOnly Property LogFileAvailable() As Boolean
            Get
                LogFileAvailable = _LogFileAvailable
            End Get
        End Property


        Private Function GetDataDirectory() As String
            Dim _PathStr As String

            ' Test for the images directory in order to find where the data directory is hidden.
            If (ApplicationDeployment.IsNetworkDeployed) Then
                _PathStr = WindowsForms.Application.UserAppDataPath
            Else
                ' Determine whether it's in the exe directory, or in a debug folder dir.
                _PathStr = WindowsForms.Application.ExecutablePath.Substring(0, _
                    WindowsForms.Application.ExecutablePath.LastIndexOf("\"))
                If (Not Directory.Exists(_PathStr & "\images")) Then
                    _PathStr = _PathStr & "\..\.."
                    If (Not Directory.Exists(_PathStr & "\images")) Then
                        Throw New DirectoryNotFoundException("Cannot find directory " & _PathStr & "\images. Fatal error.")
                    End If
                End If
            End If

            GetDataDirectory = _PathStr
        End Function

        Public Sub AddLogFileEntry(ByVal StartTime As DateTime, ByVal Hours As Integer, ByVal Minutes As Integer, ByVal Seconds As Integer)
            If (_LogFileAvailable) Then
                ' Get Sessions node.
                Dim _Elem As XmlElement = _XmlDoc.SelectSingleNode("Countdown/Sessions")
                Dim _SessionElem As XmlElement = _XmlDoc.CreateElement("Session")
                _Elem.AppendChild(_SessionElem)

                Dim _SubElem As XmlElement = _XmlDoc.CreateElement("StartDate")
                _SubElem.InnerText = StartTime.ToShortDateString()
                _SessionElem.AppendChild(_SubElem)

                _SubElem = _XmlDoc.CreateElement("StartTime")
                _SubElem.InnerText = StartTime.ToShortTimeString()
                _SessionElem.AppendChild(_SubElem)

                _SubElem = _XmlDoc.CreateElement("HourDuration")
                _SubElem.InnerText = Hours
                _SessionElem.AppendChild(_SubElem)

                _SubElem = _XmlDoc.CreateElement("MinuteDuration")
                _SubElem.InnerText = Minutes
                _SessionElem.AppendChild(_SubElem)

                _SubElem = _XmlDoc.CreateElement("SecondDuration")
                _SubElem.InnerText = Seconds
                _SessionElem.AppendChild(_SubElem)

                ' Write out the file.
                WriteXmlFile()
            End If
        End Sub
    End Class
End Namespace