'---------------------------------------------------------------------
'  Copyright (C) Microsoft Corporation.  All rights reserved.

'THIS CODE AND INFORMATION ARE PROVIDED AS IS WITHOUT WARRANTY OF ANY
'KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
'IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
'PARTICULAR PURPOSE.
'---------------------------------------------------------------------

Public Class CDHomePanel

    Private Sub CDHomePanel_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

    End Sub

    ' Detect whether countdown logging is enabled, and adjust the display accordingly. This is handled in 
    ' VisibleChanged to handle the user switching logging in the middle of the session.
    Private Sub CDHomePanel_VisibleChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.VisibleChanged
        If (Me.Visible) Then
            If (Not My.Settings.LogSessions) Then
                ViewLogLabel.Enabled = False
                LoggingEnabledLabel.Text = My.Resources.CountdownLoggingDisabledText
            Else
                ViewLogLabel.Enabled = True
                LoggingEnabledLabel.Text = My.Resources.CountdownLoggingEnabledText
            End If
        End If
    End Sub

    Private Sub ViewLogLabel_LinkClicked(ByVal sender As System.Object, ByVal e As System.Windows.Forms.LinkLabelLinkClickedEventArgs) Handles ViewLogLabel.LinkClicked
        Dim _Data As New ViewCountdownLog()
        _Data.ShowDialog()
    End Sub
End Class
