'---------------------------------------------------------------------
'  Copyright (C) Microsoft Corporation.  All rights reserved.

'THIS CODE AND INFORMATION ARE PROVIDED AS IS WITHOUT WARRANTY OF ANY
'KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
'IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
'PARTICULAR PURPOSE.
'---------------------------------------------------------------------

Imports System.IO
Imports System.Media

Public Class CDSettingsPanel
    Implements IPanelNavigating

    Private _SettingsChanged As Boolean = False

    Private Sub SelectSoundFileButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles SelectSoundFileButton.Click
        Dim _Dr As DialogResult = SelectFileDialog.ShowDialog()
        If (_Dr = DialogResult.OK) Then
            SoundFileText.Text = SelectFileDialog.FileName

            ' Mark the settings as changed.
            _SettingsChanged = True
        End If
    End Sub

    Public Function CanNavigate() As Boolean Implements IPanelNavigating.CanNavigate
        If (_SettingsChanged) Then
            Dim _Dr As DialogResult = MessageBox.Show("There are unsaved changes. Save them?", _
                "Unsaved Settings Changes", MessageBoxButtons.YesNo, MessageBoxIcon.Question, MessageBoxDefaultButton.Button1)
            If (_Dr = DialogResult.Yes) Then
                My.Settings.Save()
            Else
                ' Revert to old values.
                My.Settings.Reload()
            End If

            _SettingsChanged = False
        End If

        CanNavigate = True
    End Function

    Private Sub SaveButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles SaveButton.Click
        My.Settings.Save()
    End Sub

    Private Sub TestSoundButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles TestSoundButton.Click
        If (SoundFileText.Text.Length > 0 And File.Exists(SoundFileText.Text)) Then
            My.Computer.Audio.Play(SoundFileText.Text)
        End If
    End Sub

    Private Sub SoundFileText_TextChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles SoundFileText.TextChanged
        If (SoundFileText.Text.Length > 0) Then
            TestSoundButton.Enabled = True
        Else
            TestSoundButton.Enabled = False
        End If
    End Sub
End Class