'---------------------------------------------------------------------
'  Copyright (C) Microsoft Corporation.  All rights reserved.

'THIS CODE AND INFORMATION ARE PROVIDED AS IS WITHOUT WARRANTY OF ANY
'KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
'IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
'PARTICULAR PURPOSE.
'---------------------------------------------------------------------

Imports System.Threading
Imports System.Drawing.Drawing2D
Imports System.Reflection
Imports System.Runtime.Remoting
Imports System.IO
Imports System.Deployment.Application

Public Class Form
    Private _MouseOffset As Point
    Private _IsMouseDown As Boolean = False

    Private _CurrentClickedButton As ToolStripButton = Nothing
    Private _CurrentControl As Control

    Private _DataDirectory As String

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        ' Load up an initial image from the image directory. 
        ' Test first for this directory under UserAppDataPath. If it isn't there, the application is likely
        ' running under the debugger, so look for the files in the exe path.
        _DataDirectory = My.Application.DataDirectory
        Slideshow1.ImagePath = _DataDirectory & "\images"
        Slideshow1.StartSlideshow(6000, True)

        ' Set the default sound, if the current sound does not exist.
        If (My.Settings.SoundFile.Length = 0 Or Not File.Exists(My.Settings.SoundFile)) Then
            My.Settings.SoundFile = _DataDirectory & "\sounds\CountdownFinished.wav"
            My.Settings.Save()
        End If

        ToolStripLabel1.Text = Me.Text

        ' Default to the Home panel.
        Dim HomePanel As New CDHomePanel()
        HomePanel.Tag = "Countdown.CDHomePanel"
        HomePanel.Dock = DockStyle.Fill
        SplitContainer1.Panel1.Controls.Add(HomePanel)
        _CurrentControl = HomePanel
        _CurrentClickedButton = HomeButton
    End Sub

    Private Sub AppCloseButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles AppCloseButton.Click
        Me.Close()
    End Sub

    Private Sub AppMinimizeButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles AppMinimizeButton.Click
        Me.WindowState = FormWindowState.Minimized
    End Sub

    Private Sub TitleStrip_MouseDown(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles TitleStrip.MouseDown
        If e.Button = System.Windows.Forms.MouseButtons.Left Then
            _MouseOffset = New Point(e.X, e.Y)
            _IsMouseDown = True
            TitleStrip.Capture = True
        End If
    End Sub

    '! TODO: My logic is too simplistic. Figure out why.
    Private Sub TitleStrip_MouseMove(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles TitleStrip.MouseMove
        If _IsMouseDown Then
            Dim _CurrentPos As Point = Control.MousePosition
            _CurrentPos.X = _CurrentPos.X - _MouseOffset.X
            _CurrentPos.Y = _CurrentPos.Y - _MouseOffset.Y
            Me.Location = _CurrentPos
        End If
    End Sub

    Private Sub TitleStrip_MouseUp(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles TitleStrip.MouseUp
        ' Changes the isMouseDown field so that the form does
        ' not move unless the user is pressing the left mouse button.
        If e.Button = System.Windows.Forms.MouseButtons.Left Then
            _IsMouseDown = False
            TitleStrip.Capture = False
        End If
    End Sub

    Private Sub ToolStripButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles HomeButton.Click, CountdownButton.Click, SettingsButton.Click

    End Sub

    ' The Settings panel might have unsaved data on it, and the Countdown panel
    ' will want to cancel the meditation clock if the user navigates to a new
    ' panel. Handle the mouse down, and determine if the application
    ' should navigate away from this panel or cancel the click.
    Private Sub ToolStripButton_MouseDown(ByVal sender As System.Object, ByVal e As MouseEventArgs) Handles HomeButton.MouseDown, CountdownButton.MouseDown, SettingsButton.MouseDown
        ' Attempt to cast to an IPanelNavigating. If not implemented, 
        ' just navigate.
        If (TypeOf _CurrentControl Is IPanelNavigating) Then
            Dim _CanNavigate As IPanelNavigating = CType(_CurrentControl, IPanelNavigating)
            If (_CanNavigate.CanNavigate()) Then
                Navigate(sender)
            End If
        Else
            ' Just navigate.
            Navigate(sender)
        End If
    End Sub

    Private Sub Navigate(ByVal sender As Object)
        Dim _NewControl As Control
        '  TODO: Error handling!
        Dim _CurrentButton As ToolStripButton = CType(sender, ToolStripButton)
        Dim _ControlName As String = _CurrentButton.Tag.ToString()

        ' Uncheck the previous clicked button.
        _CurrentClickedButton.Checked = False
        _CurrentClickedButton = _CurrentButton

        ' First, make sure this isn't a redundant event - is the control already displayed?
        If (Not (_ControlName = _CurrentControl.Name)) Then
            ' Get the control to use, and instantiate it dynamically if it isn't already defined.
            _NewControl = SplitContainer1.Panel1.Controls(_ControlName)
            If (_NewControl Is Nothing) Then
                ' Control not found - instantiate it.
                Dim _Oh As ObjectHandle = AppDomain.CurrentDomain.CreateInstance(Assembly.GetExecutingAssembly().FullName, _ControlName)
                _NewControl = _Oh.Unwrap()
                _NewControl.Name = _ControlName
                _NewControl.Dock = DockStyle.Fill
                SplitContainer1.Panel1.Controls.Add(_NewControl)
            End If

            ' Hide the old control, and show the new one. 
            _CurrentControl.Visible = False
            _NewControl.Visible = True
            _CurrentControl = _NewControl
        End If
    End Sub
End Class