'---------------------------------------------------------------------
'  Copyright (C) Microsoft Corporation.  All rights reserved.

'THIS CODE AND INFORMATION ARE PROVIDED AS IS WITHOUT WARRANTY OF ANY
'KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
'IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
'PARTICULAR PURPOSE.
'---------------------------------------------------------------------

Imports System.Xml
Imports System.Data

Public Class ViewCountdownLog
    Private Sub ViewCountdownLog_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        ' Load data.
        Dim _Data As New XmlDocument()
        _Data.Load(My.Application.DataDirectory & "\log.xml")

        ' Since the user won't modify this data, let's bypass binding and do this ourselves.
        ' This will let us transform the data before shoving it into datagridview cells.
        For Each _Elem As XmlElement In _Data.SelectNodes("Countdown/Sessions/Session")
            Dim _Duration As String = _Elem.SelectSingleNode("HourDuration").InnerText & "h " & _
                _Elem.SelectSingleNode("MinuteDuration").InnerText & "m " & _
                _Elem.SelectSingleNode("SecondDuration").InnerText & "s"
            DataGridView1.Rows.Add(_Elem.SelectSingleNode("StartDate").InnerText, _
                _Elem.SelectSingleNode("StartTime").InnerText, _Duration)
        Next
    End Sub
End Class