'---------------------------------------------------------------------
'  Copyright (C) Microsoft Corporation.  All rights reserved.

'THIS CODE AND INFORMATION ARE PROVIDED AS IS WITHOUT WARRANTY OF ANY
'KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
'IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
'PARTICULAR PURPOSE.
'---------------------------------------------------------------------

Imports System.Collections.Generic

Public Class CollapsibleControl
    Dim SectionList As List(Of CollapsibleControlSection)
    Private _CControlCounter As Integer = 0

    Public Sub New()
        ' This call is required by the Windows Form Designer.
        InitializeComponent()

        SectionList = New List(Of CollapsibleControlSection)()
    End Sub

    Public Sub AddSection(ByVal NewSection As CollapsibleControlSection)
        SectionList.Add(NewSection)
        ' Add a new row. 
        Dim Header As New ListHeader()
        Header.Text = NewSection.SectionName
        Header.Width = Me.Width
        AddHandler Header.ListHeaderStateChanged, AddressOf Header_ListHeaderStateChanged
        FlowLayoutPanel1.Controls.Add(Header)
        ' Get the position of the control to add, so that the application can show and hide it when needed.
        Header.Tag = "CollapsibleControl" & _CControlCounter
        _CControlCounter += 1

        Dim c As Control = NewSection.SectionControl
        c.Width = Me.Width
        c.Name = Header.Tag
        FlowLayoutPanel1.Controls.Add(c)
    End Sub

    Sub Header_ListHeaderStateChanged(ByVal sender As Object, ByVal e As ListHeaderStateChangedEventArgs)
        Dim header As ListHeader = CType(sender, ListHeader)
        Dim c As Control = FlowLayoutPanel1.Controls(CStr(header.Tag))

        If e.State = ListHeaderState.Collapsed Then
            c.Hide()
        Else
            c.Show()
        End If
    End Sub
End Class

Public Class CollapsibleControlSection
    Inherits Object

    Private _SectionName As String = Nothing
    Private _Control As Control = Nothing


    Public Sub New(ByVal sectionName As String, ByVal control As Control)
        _SectionName = sectionName
        _Control = control
    End Sub


    Public Property SectionName() As String
        Get
            Return _SectionName
        End Get
        Set(ByVal value As String)
            _SectionName = value
        End Set
    End Property

    Public Property SectionControl() As Control
        Get
            Return _Control
        End Get
        Set(ByVal value As Control)
            _Control = value
        End Set
    End Property
End Class