'---------------------------------------------------------------------
'  Copyright (C) Microsoft Corporation.  All rights reserved.

'THIS CODE AND INFORMATION ARE PROVIDED AS IS WITHOUT WARRANTY OF ANY
'KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
'IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
'PARTICULAR PURPOSE.
'---------------------------------------------------------------------

Imports System.Runtime.Remoting
Imports System.Reflection

Public Class FlyoutForm

    Dim _DoFade As Boolean = False
    Dim _HaveProcessedMouseEnter As Boolean = False
    Dim _CurrentControl As Control = Nothing
    Dim _CachedControlPoint As Point = Nothing

    Sub ToolBoxLabel_MouseEnter(ByVal sender As Object, ByVal e As EventArgs) Handles ToolBoxLabel.MouseEnter
        If Not _HaveProcessedMouseEnter Then
            _HaveProcessedMouseEnter = True

            ' Make sure the panel is not still fading. If it is fading, it means the user has re-entered the
            ' label area during fade processing. In that case, reverse course and show the panel instead.
            If (_DoFade) Then
                PanelTimer.Stop()
                _DoFade = False
            ElseIf _CurrentControl Is Nothing Then
                ' Get the control to use, and instantiate it dynamically.
                Dim controlName As String = CType(sender, ToolStripLabel).Tag.ToString()
                Dim oh As ObjectHandle = AppDomain.CurrentDomain.CreateInstance(Assembly.GetExecutingAssembly().FullName, controlName)
                _CurrentControl = CType(oh.Unwrap(), Control)
                _CurrentControl.Height = Me.Height
                _CurrentControl.Location = New Point(toolStrip1.Location.X + toolStrip1.Width - _CurrentControl.Width, 0)
                _CachedControlPoint = _CurrentControl.Location

                Me.SuspendLayout()

                Me.Controls.Add(_CurrentControl)

                ' The following calls make the panel appear above all other controls on the form,
                ' *except* the ToolStrip with the panel buttons.
                _CurrentControl.BringToFront()
                toolStrip1.BringToFront()

                Me.ResumeLayout()
            End If

            PanelTimer.Start()
            End If
    End Sub 'toolBoxLabel_MouseEnter

    Sub ToolBoxLabel_MouseLeave(ByVal sender As Object, ByVal e As EventArgs) Handles ToolBoxLabel.MouseLeave
        ' Slight problem: The application could be transitioning between the ToolStrip and the flyout panel. If the
        ' mouse is in an inbetween state where it's not over the ToolStripLabel but *is* over the
        ' thin wedge of the ToolStrip itself, the application will fade the panel erroneously. This
        ' timer gives the user time to transition. The delay built into VS is about 1 second; that 
        ' should work well here.
        MouseLeaveTimer.Start()
    End Sub


    Private Sub PanelTimer_Tick(ByVal sender As Object, ByVal e As EventArgs) Handles PanelTimer.Tick
        If _DoFade Then
            ' Hide the panel.
            If _CachedControlPoint.X + _CurrentControl.Size.Width > toolStrip1.Location.X + toolStrip1.Width Then
                _CachedControlPoint.Offset(-20, 0)
                _CurrentControl.Location = _CachedControlPoint
            Else
                PanelTimer.Stop()
                _HaveProcessedMouseEnter = False
                _DoFade = False
            End If
        Else
            ' Show the panel.
            If _CachedControlPoint.X < toolStrip1.Location.X + toolStrip1.Width Then
                _CachedControlPoint.Offset(20, 0)
                _CurrentControl.Location = _CachedControlPoint
            Else
                PanelTimer.Stop()
                _HaveProcessedMouseEnter = False
                _DoFade = True
            End If
        End If
    End Sub

    Private Sub MouseLeaveTimer_Tick(ByVal sender As Object, ByVal e As EventArgs) Handles MouseLeaveTimer.Tick
        ' If the user's mouse is over the flyout panel, don't trigger the leave event. 
        Dim controlUnderMouse As Control = Me.GetChildAtPoint(Me.PointToClient(System.Windows.Forms.Cursor.Position))

        ' This might get whatever child control is under the ToolStrip. Inspect
        ' parent controls until the application reaches the Form. If it doesn't find a control that matches
        ' _CurrentControl in the parenting chain, fade.
        Dim overPanel As Boolean = False
        While controlUnderMouse IsNot Me
            ' If the application is over the blank form area, controlOverMouse will be null.
            If controlUnderMouse Is Nothing Then
                overPanel = False
                Exit While
            End If

            If controlUnderMouse Is _CurrentControl Then
                overPanel = True
                Exit While
            End If

            controlUnderMouse = controlUnderMouse.Parent
        End While
        If Not overPanel Then
            ' Since the mouse must leave the panel area SOMETIME, keep checking until it has left. 
            MouseLeaveTimer.Stop()
            PanelTimer.Start()
        End If
    End Sub
End Class