'---------------------------------------------------------------------
'  Copyright (C) Microsoft Corporation.  All rights reserved.

'THIS CODE AND INFORMATION ARE PROVIDED AS IS WITHOUT WARRANTY OF ANY
'KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
'IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
'PARTICULAR PURPOSE.
'---------------------------------------------------------------------

Imports System.Drawing.Drawing2D
Imports System.Resources
Imports System.ComponentModel

Public Class ListHeader

    Dim _Text As String
    Dim _IsMinus = True
    Dim _Rm As ResourceManager

    Event ListHeaderStateChanged As ListHeaderStateChangedEventHandler

    Private Sub ListHeader_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        _Rm = New ResourceManager(Me.GetType())
    End Sub

    ' The text to display inside the control.
    <Browsable(True), DesignerSerializationVisibility(DesignerSerializationVisibility.Visible)> _
    Public Overrides Property Text() As String
        Get
            Return _Text
        End Get
        Set(ByVal value As String)
            _Text = value
        End Set
    End Property

    Private Sub ListHeader_Paint(ByVal sender As Object, ByVal e As System.Windows.Forms.PaintEventArgs) Handles Me.Paint
        Dim brush As New LinearGradientBrush(New Rectangle(0, 0, Me.Width, Me.Height), Color.FromArgb(219, 217, 200), Color.FromArgb(196, 193, 176), 90)
        e.Graphics.FillRectangle(brush, New Rectangle(0, 0, Me.Width, Me.Height))

        ' Render the text next to the plus/minus box.
        Dim textOffsetX As Integer = pictureBox1.Location.X + pictureBox1.Width
        Dim textRect As New RectangleF(textOffsetX + 4, 0, Me.Width - textOffsetX, Me.Height)
        Dim textFormat As New StringFormat()
        textFormat.Alignment = StringAlignment.Near
        textFormat.LineAlignment = StringAlignment.Center
        e.Graphics.DrawString(Me.Text, Me.Font, New SolidBrush(Me.ForeColor), textRect, textFormat)
    End Sub


    Private Sub pictureBox1_Click(ByVal sender As Object, ByVal e As EventArgs) Handles pictureBox1.Click
        Dim plusImage As Image

        If _IsMinus Then
            plusImage = My.Resources.plusbox
            _IsMinus = False
            OnListHeaderStateChanged(New ListHeaderStateChangedEventArgs(ListHeaderState.Collapsed))
        Else
            plusImage = My.Resources.minus
            _IsMinus = True
            OnListHeaderStateChanged(New ListHeaderStateChangedEventArgs(ListHeaderState.Expanded))
        End If

        pictureBox1.Image = plusImage
    End Sub 'pictureBox1_Click

    Protected Overridable Sub OnListHeaderStateChanged(ByVal e As ListHeaderStateChangedEventArgs)
        RaiseEvent ListHeaderStateChanged(Me, e)
    End Sub
End Class

Public Class ListHeaderStateChangedEventArgs
    Inherits EventArgs
    Private _State As ListHeaderState


    Public Sub New(ByVal state As ListHeaderState)
        _State = state
    End Sub


    Public ReadOnly Property State() As ListHeaderState
        Get
            Return _State
        End Get
    End Property
End Class

Public Enum ListHeaderState
    Expanded = 0
    Collapsed
End Enum

Public Delegate Sub ListHeaderStateChangedEventHandler(ByVal sender As Object, ByVal e As ListHeaderStateChangedEventArgs)