/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.ssh2;

import com.maverick.crypto.io.ByteArrayReader;
import com.maverick.crypto.io.ByteArrayWriter;
import com.maverick.ssh.ChannelEventListener;
import com.maverick.ssh.ChannelOpenException;
import com.maverick.ssh.ForwardingRequestListener;
import com.maverick.ssh.PasswordAuthentication;
import com.maverick.ssh.PublicKeyAuthentication;
import com.maverick.ssh.SshAuthentication;
import com.maverick.ssh.SshClient;
import com.maverick.ssh.SshConnector;
import com.maverick.ssh.SshContext;
import com.maverick.ssh.SshException;
import com.maverick.ssh.SshSession;
import com.maverick.ssh.SshTransport;
import com.maverick.ssh.SshTunnel;
import com.maverick.ssh.message.SshAbstractChannel;
import com.maverick.ssh2.A;
import com.maverick.ssh2.C;
import com.maverick.ssh2.ChannelFactory;
import com.maverick.ssh2.D;
import com.maverick.ssh2.G;
import com.maverick.ssh2.GlobalRequest;
import com.maverick.ssh2.GlobalRequestHandler;
import com.maverick.ssh2.Ssh2Channel;
import com.maverick.ssh2.Ssh2Context;
import com.maverick.ssh2.Ssh2PasswordAuthentication;
import com.maverick.ssh2.Ssh2PublicKeyAuthentication;
import com.maverick.ssh2.Ssh2Session;
import com.maverick.ssh2.TransportProtocol;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;

public class Ssh2Client
implements SshClient {
    TransportProtocol U;
    SshTransport Z;
    D Y;
    A Q;
    String V;
    String _;
    String[] X;
    String W;
    Hashtable c = new Hashtable();
    Hashtable b = new Hashtable();
    _A a = new _A();
    SshAuthentication R;
    SshConnector T;
    boolean P = false;
    boolean S;

    public void connect(SshTransport sshTransport, SshContext sshContext, SshConnector sshConnector, String string, String string2, String string3, boolean bl) throws SshException {
        if (sshConnector == null || !sshConnector.isLicensed()) {
            throw new SshException("You cannot create Ssh2Client instances directly", 4);
        }
        this.Z = sshTransport;
        this.V = string2;
        this._ = string3;
        this.W = string;
        this.S = bl;
        this.T = sshConnector;
        if (string == null) {
            try {
                sshTransport.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new SshException("You must supply a valid username!", 4);
        }
        if (!(sshContext instanceof Ssh2Context)) {
            try {
                sshTransport.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new SshException("Ssh2Context required!", 4);
        }
        this.U = new TransportProtocol();
        this.U.startTransportProtocol(sshTransport, (Ssh2Context)sshContext, string2, string3);
        this.Y = new D(this.U);
        this.Y.A(((Ssh2Context)sshContext).getBannerDisplay());
        this.Q = new A(this.U, sshContext, bl);
        this.Q.A(this.a);
        this.getAuthenticationMethods(string);
    }

    public String[] getAuthenticationMethods(String string) throws SshException {
        this.A(false);
        if (this.X == null) {
            String string2 = this.Y.A(string, "ssh-connection");
            Vector<String> vector = new Vector<String>();
            while (string2 != null) {
                int n = string2.indexOf(44);
                if (n > -1) {
                    vector.addElement(string2.substring(0, n));
                    string2 = string2.substring(n + 1);
                    continue;
                }
                vector.addElement(string2);
                string2 = null;
            }
            this.X = new String[vector.size()];
            vector.copyInto(this.X);
        }
        return this.X;
    }

    public int authenticate(SshAuthentication sshAuthentication) throws SshException {
        int n;
        this.A(false);
        if (this.isAuthenticated()) {
            throw new SshException("User is already authenticated! Did you check isAuthenticated?", 4);
        }
        if (sshAuthentication.getUsername() == null) {
            sshAuthentication.setUsername(this.W);
        }
        if (sshAuthentication instanceof PasswordAuthentication && !(sshAuthentication instanceof Ssh2PasswordAuthentication)) {
            Ssh2PasswordAuthentication ssh2PasswordAuthentication = new Ssh2PasswordAuthentication();
            ssh2PasswordAuthentication.setUsername(((PasswordAuthentication)sshAuthentication).getUsername());
            ssh2PasswordAuthentication.setPassword(((PasswordAuthentication)sshAuthentication).getPassword());
            n = this.Y.A(ssh2PasswordAuthentication, "ssh-connection");
            if (ssh2PasswordAuthentication.requiresPasswordChange()) {
                this.disconnect();
                throw new SshException("Password change required!", 8);
            }
        } else if (sshAuthentication instanceof PublicKeyAuthentication && !(sshAuthentication instanceof Ssh2PublicKeyAuthentication)) {
            Ssh2PublicKeyAuthentication ssh2PublicKeyAuthentication = new Ssh2PublicKeyAuthentication();
            ssh2PublicKeyAuthentication.setUsername(((PublicKeyAuthentication)sshAuthentication).getUsername());
            ssh2PublicKeyAuthentication.setPublicKey(((PublicKeyAuthentication)sshAuthentication).getPublicKey());
            ssh2PublicKeyAuthentication.setPrivateKey(((PublicKeyAuthentication)sshAuthentication).getPrivateKey());
            n = this.Y.A(ssh2PublicKeyAuthentication, "ssh-connection");
        } else if (sshAuthentication instanceof C) {
            n = this.Y.A((C)sshAuthentication, "ssh-connection");
        } else {
            throw new SshException("Invalid authentication client", 4);
        }
        if (n == 1) {
            this.R = sshAuthentication;
            this.Q.start();
        }
        return n;
    }

    public boolean isAuthenticated() {
        return this.Y.B();
    }

    public void disconnect() {
        try {
            this.Q.signalClosingState();
            this.U.disconnect(11, "The user disconnected the application");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean isConnected() {
        return this.U.isConnected();
    }

    public void forceKeyExchange() throws SshException {
        this.U.H();
    }

    public SshSession openSessionChannel() throws SshException, ChannelOpenException {
        return this.openSessionChannel(32768, 32768, null);
    }

    public SshSession openSessionChannel(ChannelEventListener channelEventListener) throws SshException, ChannelOpenException {
        return this.openSessionChannel(32768, 32768, channelEventListener);
    }

    public Ssh2Session openSessionChannel(int n, int n2, ChannelEventListener channelEventListener) throws ChannelOpenException, SshException {
        this.A(true);
        Ssh2Session ssh2Session = new Ssh2Session(n, n2, this);
        if (channelEventListener != null) {
            ssh2Session.addChannelEventListener(channelEventListener);
        }
        this.Q.A(ssh2Session, null);
        if (this.Q.F().getX11Display() != null) {
            String string = this.Q.F().getX11Display();
            int n3 = string.indexOf(58);
            int n4 = 0;
            n4 = n3 != -1 ? Integer.parseInt(string.substring(n3 + 1)) : Integer.parseInt(string);
            byte[] byArray = this.Q.F().getX11AuthenticationCookie();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < 16; ++i) {
                String string2 = Integer.toHexString(byArray[i] & 0xFF);
                if (string2.length() == 1) {
                    string2 = "0" + string2;
                }
                stringBuffer.append(string2);
            }
            if (ssh2Session.A(false, "MIT-MAGIC-COOKIE-1", stringBuffer.toString(), n4)) {
                this.P = true;
            }
        }
        return ssh2Session;
    }

    public SshClient openRemoteClient(String string, int n, String string2, SshConnector sshConnector) throws SshException, ChannelOpenException {
        SshTunnel sshTunnel = this.openForwardingChannel(string, n, "127.0.0.1", 22, "127.0.0.1", 22, null, null);
        return sshConnector.connect((SshTransport)sshTunnel, string2);
    }

    public SshClient openRemoteClient(String string, int n, String string2) throws SshException, ChannelOpenException {
        return this.openRemoteClient(string, n, string2, this.T);
    }

    public SshTunnel openForwardingChannel(String string, int n, String string2, int n2, String string3, int n3, SshTransport sshTransport, ChannelEventListener channelEventListener) throws SshException, ChannelOpenException {
        try {
            G g = new G("direct-tcpip", 32768, 32768, string, n, string2, n2, string3, n3, sshTransport);
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byteArrayWriter.writeString(string);
            byteArrayWriter.writeInt(n);
            byteArrayWriter.writeString(string3);
            byteArrayWriter.writeInt(n3);
            g.addChannelEventListener(channelEventListener);
            this.openChannel(g, byteArrayWriter.toByteArray());
            return g;
        }
        catch (IOException iOException) {
            throw new SshException(iOException.getMessage(), 5);
        }
    }

    public boolean requestRemoteForwarding(String string, int n, String string2, int n2, ForwardingRequestListener forwardingRequestListener) throws SshException {
        try {
            if (forwardingRequestListener == null) {
                throw new SshException("You must specify a listener to receive connection requests", 4);
            }
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byteArrayWriter.writeString(string);
            byteArrayWriter.writeInt(n);
            GlobalRequest globalRequest = new GlobalRequest("tcpip-forward", byteArrayWriter.toByteArray());
            if (this.sendGlobalRequest(globalRequest, true)) {
                this.c.put(string + ":" + String.valueOf(n), forwardingRequestListener);
                this.b.put(string + ":" + String.valueOf(n), string2 + ":" + String.valueOf(n2));
                return true;
            }
            return false;
        }
        catch (IOException iOException) {
            throw new SshException(iOException.getMessage(), 5);
        }
    }

    public boolean cancelRemoteForwarding(String string, int n) throws SshException {
        try {
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byteArrayWriter.writeString(string);
            byteArrayWriter.writeInt(n);
            GlobalRequest globalRequest = new GlobalRequest("cancel-tcpip-forward", byteArrayWriter.toByteArray());
            if (this.sendGlobalRequest(globalRequest, true)) {
                this.c.remove(string + ":" + String.valueOf(n));
                this.b.remove(string + ":" + String.valueOf(n));
                return true;
            }
            return false;
        }
        catch (IOException iOException) {
            throw new SshException(iOException.getMessage(), 5);
        }
    }

    public void openChannel(Ssh2Channel ssh2Channel, byte[] byArray) throws SshException, ChannelOpenException {
        this.A(true);
        this.Q.A(ssh2Channel, byArray);
    }

    public void openChannel(SshAbstractChannel sshAbstractChannel) throws SshException, ChannelOpenException {
        this.A(true);
        if (!(sshAbstractChannel instanceof Ssh2Channel)) {
            throw new SshException("The channel is not an SSH2 channel!", 4);
        }
        this.Q.A((Ssh2Channel)sshAbstractChannel, null);
    }

    public void addChannelFactory(ChannelFactory channelFactory) throws SshException {
        this.Q.A(channelFactory);
    }

    public SshContext getContext() {
        return this.U.\u00b5;
    }

    public void addRequestHandler(GlobalRequestHandler globalRequestHandler) throws SshException {
        this.Q.A(globalRequestHandler);
    }

    public boolean sendGlobalRequest(GlobalRequest globalRequest, boolean bl) throws SshException {
        this.A(true);
        return this.Q.A(globalRequest, bl);
    }

    public String getRemoteIdentification() {
        return this._;
    }

    void A(boolean bl) throws SshException {
        if (this.Y == null || this.U == null || this.Q == null) {
            throw new SshException("Not connected!", 4);
        }
        if (!this.U.isConnected()) {
            throw new SshException("The connection has been terminated!", 2);
        }
        if (!this.Y.B() && bl) {
            throw new SshException("The connection is not authenticated!", 4);
        }
    }

    public String getUsername() {
        return this.W;
    }

    public SshClient duplicate() throws SshException {
        if (this.W == null || this.R == null) {
            throw new SshException("Cannot duplicate! The existing connection does not have a set of credentials", 4);
        }
        try {
            SshClient sshClient = this.T.connect(this.Z.duplicate(), this.W, this.S, (SshContext)this.U.\u00b5);
            if (sshClient.authenticate(this.R) != 1) {
                sshClient.disconnect();
                throw new SshException("Duplication attempt failed to authenicate user!", 5);
            }
            return sshClient;
        }
        catch (IOException iOException) {
            throw new SshException(iOException.getMessage(), 10);
        }
    }

    public int getChannelCount() {
        return this.Q.getChannelCount();
    }

    public int getVersion() {
        return 2;
    }

    public boolean isBuffered() {
        return this.S;
    }

    public String getKeyExchangeInUse() {
        return this.U.\u00d4 == null ? "none" : this.U.\u00d4.getAlgorithm();
    }

    public String getHostKeyInUse() {
        return this.U.l == null ? "none" : this.U.l.getAlgorithm();
    }

    public String getCipherInUseCS() {
        return this.U.\u00cc == null ? "none" : this.U.\u00cc.getAlgorithm();
    }

    public String getCipherInUseSC() {
        return this.U.\u00c5 == null ? "none" : this.U.\u00c5.getAlgorithm();
    }

    public String getMacInUseCS() {
        return this.U.v == null ? "none" : this.U.v.getAlgorithm();
    }

    public String getMacInUseSC() {
        return this.U.\u00c1 == null ? "none" : this.U.\u00c1.getAlgorithm();
    }

    public String getCompressionInUseCS() {
        return this.U.\u00d2 == null ? "none" : this.U.\u00d2.getAlgorithm();
    }

    public String getCompressionInUseSC() {
        return this.U.\u00a5 == null ? "none" : this.U.\u00a5.getAlgorithm();
    }

    public String toString() {
        return "SSH2 " + this.Z.getHost() + ":" + this.Z.getPort() + " [kex=" + (this.U.\u00d4 == null ? "none" : this.U.\u00d4.getAlgorithm()) + " hostkey=" + (this.U.l == null ? "none" : this.U.l.getAlgorithm()) + " client->server=" + (this.U.\u00cc == null ? "none" : this.U.\u00cc.getAlgorithm()) + "," + (this.U.v == null ? "none" : this.U.v.getAlgorithm()) + "," + (this.U.\u00d2 == null ? "none" : this.U.\u00d2.getAlgorithm()) + " server->client=" + (this.U.\u00c5 == null ? "none" : this.U.\u00c5.getAlgorithm()) + "," + (this.U.\u00c1 == null ? "none" : this.U.\u00c1.getAlgorithm()) + "," + (this.U.\u00a5 == null ? "none" : this.U.\u00a5.getAlgorithm()) + "]";
    }

    class _A
    implements ChannelFactory {
        String[] A = new String[]{"forwarded-tcpip", "x11"};

        _A() {
        }

        public String[] supportedChannelTypes() {
            return this.A;
        }

        public Ssh2Channel createChannel(String string, byte[] byArray) throws SshException, ChannelOpenException {
            if (string.equals("forwarded-tcpip")) {
                try {
                    ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
                    String string2 = byteArrayReader.readString();
                    int n = (int)byteArrayReader.readInt();
                    String string3 = byteArrayReader.readString();
                    int n2 = (int)byteArrayReader.readInt();
                    String string4 = string2 + ":" + String.valueOf(n);
                    if (Ssh2Client.this.c.containsKey(string4)) {
                        ForwardingRequestListener forwardingRequestListener = (ForwardingRequestListener)Ssh2Client.this.c.get(string4);
                        String string5 = (String)Ssh2Client.this.b.get(string4);
                        String string6 = string5.substring(0, string5.indexOf(58));
                        int n3 = Integer.parseInt(string5.substring(string5.indexOf(58) + 1));
                        G g = new G("forwarded-tcpip", 32768, 32768, string6, n3, string2, n, string3, n2, forwardingRequestListener.createConnection(string6, n3));
                        forwardingRequestListener.initializeTunnel((SshTunnel)g);
                        return g;
                    }
                    throw new ChannelOpenException("Forwarding had not previously been requested", 1);
                }
                catch (IOException iOException) {
                    throw new ChannelOpenException(iOException.getMessage(), 4);
                }
                catch (SshException sshException) {
                    throw new ChannelOpenException(sshException.getMessage(), 2);
                }
            }
            if (string.equals("x11")) {
                if (!Ssh2Client.this.P) {
                    throw new ChannelOpenException("X Forwarding had not previously been requested", 1);
                }
                try {
                    int n;
                    String string7;
                    ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
                    String string8 = byteArrayReader.readString();
                    int n4 = (int)byteArrayReader.readInt();
                    String string9 = Ssh2Client.this.Q.F().getX11Display();
                    int n5 = string9.indexOf(":");
                    int n6 = 0;
                    if (n5 != -1) {
                        string7 = string9.substring(0, n5);
                        n = n6 = Integer.parseInt(string9.substring(n5 + 1));
                    } else {
                        string7 = string9;
                        n = 6000;
                    }
                    if (n <= 10) {
                        n += 6000;
                    }
                    ForwardingRequestListener forwardingRequestListener = Ssh2Client.this.Q.F().getX11RequestListener();
                    G g = new G("x11", 32768, 32768, string7, n, string7, n6, string8, n4, forwardingRequestListener.createConnection(string7, n));
                    forwardingRequestListener.initializeTunnel((SshTunnel)g);
                    return g;
                }
                catch (Throwable throwable) {
                    throw new ChannelOpenException(throwable.getMessage(), 2);
                }
            }
            throw new ChannelOpenException(string + " is not supported", 3);
        }
    }
}

