/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.ssh2;

import com.maverick.crypto.digests.DigestFactory;
import com.maverick.crypto.digests.DigestProvider;
import com.maverick.crypto.digests.HMac;
import com.maverick.crypto.security.SecureRandom;
import com.maverick.ssh.ForwardingRequestListener;
import com.maverick.ssh.HostKeyVerification;
import com.maverick.ssh.SshContext;
import com.maverick.ssh.SshException;
import com.maverick.ssh2.AbstractComponentFactory;
import com.maverick.ssh2.BannerDisplay;
import com.maverick.ssh2.SshHmac;

public final class Ssh2Context
implements SshContext {
    AbstractComponentFactory b;
    AbstractComponentFactory Q;
    AbstractComponentFactory c;
    AbstractComponentFactory M;
    AbstractComponentFactory X;
    public static final String CIPHER_TRIPLEDES_CBC = "3des-cbc";
    public static final String CIPHER_BLOWFISH_CBC = "blowfish-cbc";
    public static final String HMAC_SHA1 = "hmac-sha1";
    public static final String HMAC_MD5 = "hmac-md5";
    public static final String COMPRESSION_NONE = "none";
    public static final String COMPRESSION_ZLIB = "zlib";
    public static final String KEX_DIFFIE_HELLMAN_GROUP1_SHA1 = "diffie-hellman-group1-sha1";
    public static final String KEX_DIFFIE_HELLMAN_GROUP_EXCHANGE_SHA1 = "diffie-hellman-group-exchange-sha1";
    public static final String PUBLIC_KEY_SSHDSS = "ssh-dss";
    public static final String PUBLIC_KEY_SSHRSA = "ssh-rsa";
    String L = "3des-cbc";
    String e = "3des-cbc";
    String W = "hmac-sha1";
    String P = "hmac-sha1";
    String V = "none";
    String N = "none";
    String Z = "diffie-hellman-group1-sha1";
    String a = "ssh-dss";
    String Y = "/usr/libexec/sftp-server";
    int S = 100;
    BannerDisplay U;
    HostKeyVerification K;
    String _ = null;
    byte[] d = null;
    byte[] R = null;
    ForwardingRequestListener O = null;
    String T = "";
    int f = 131072;

    public Ssh2Context() throws SshException {
        String string = System.getProperty("com.sshtools.jce.usingProvider");
        boolean bl = string != null;
        try {
            this.b = new AbstractComponentFactory(Class.forName("com.maverick.ssh.cipher.SshCipher")){

                public Object createInstance(String string, Class clazz) throws Throwable {
                    return clazz.newInstance();
                }
            };
            this.b.add(CIPHER_TRIPLEDES_CBC, Class.forName(bl ? "com.sshtools.jce.TripleDesCbc" : "com.maverick.ssh2.TripleDesCbc"));
            this.b.add(CIPHER_BLOWFISH_CBC, Class.forName(bl ? "com.sshtools.jce.BlowfishCbc" : "com.maverick.ssh2.BlowfishCbc"));
            this.A("aes128-cbc", "com.sshtools.cipher.AES128Cbc");
            this.A("aes192-cbc", "com.sshtools.cipher.AES192Cbc");
            this.A("aes256-cbc", "com.sshtools.cipher.AES256Cbc");
            this.A("twofish128-cbc", "com.sshtools.cipher.Twofish128Cbc");
            this.A("twofish192-cbc", "com.sshtools.cipher.Twofish192Cbc");
            this.A("twofish256-cbc", "com.sshtools.cipher.Twofish256Cbc");
            this.A("cast128-cbc", "com.sshtools.cipher.CAST128Cbc");
            if (this.b.contains("aes128-cbc")) {
                this.L = "aes128-cbc";
                this.e = "aes128-cbc";
            }
            this.Q = new AbstractComponentFactory(Class.forName("com.maverick.crypto.digests.HMac")){

                public Object createInstance(String string, Class clazz) throws Throwable {
                    return new SshHmac(string, (HMac)clazz.newInstance());
                }
            };
            this.Q.add(HMAC_SHA1, Class.forName(bl ? "com.sshtools.jce.SHA1HMac" : "com.maverick.ssh2.SHA1HMac"));
            this.Q.add(HMAC_MD5, Class.forName(bl ? "com.sshtools.jce.MD5HMac" : "com.maverick.ssh2.MD5HMac"));
            this.c = new AbstractComponentFactory(Class.forName("com.maverick.ssh.compression.SshCompression")){

                public Object createInstance(String string, Class clazz) throws Throwable {
                    if (!string.equals(Ssh2Context.COMPRESSION_NONE)) {
                        return clazz.newInstance();
                    }
                    return null;
                }
            };
            this.c.add(COMPRESSION_NONE, Class.forName("java.lang.Object"));
            try {
                this.c.add(COMPRESSION_ZLIB, Class.forName("com.sshtools.zlib.ZLibCompression"));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.M = new AbstractComponentFactory(Class.forName("com.maverick.ssh2.SshKeyExchange")){

                public Object createInstance(String string, Class clazz) throws Throwable {
                    return clazz.newInstance();
                }
            };
            this.M.add(KEX_DIFFIE_HELLMAN_GROUP1_SHA1, Class.forName(bl ? "com.sshtools.jce.DiffieHellmanGroup1Sha1" : "com.maverick.ssh2.B"));
            this.M.add(KEX_DIFFIE_HELLMAN_GROUP_EXCHANGE_SHA1, Class.forName(bl ? "com.sshtools.jce.DiffieHellmanGroupExchangeSha1" : "com.maverick.ssh2.F"));
            this.X = new AbstractComponentFactory(Class.forName("com.maverick.ssh.SshPublicKey")){

                public Object createInstance(String string, Class clazz) throws Throwable {
                    return clazz.newInstance();
                }
            };
            this.X.add(PUBLIC_KEY_SSHDSS, Class.forName(bl ? "com.sshtools.jce.Ssh2DsaPublicKey" : "com.maverick.ssh2.Ssh2DsaPublicKey"));
            this.X.add(PUBLIC_KEY_SSHRSA, Class.forName(bl ? "com.sshtools.jce.Ssh2RsaPublicKey" : "com.maverick.ssh2.Ssh2RsaPublicKey"));
            if (bl) {
                DigestFactory.setProvider((DigestProvider)((DigestProvider)Class.forName("com.sshtools.jce.JCEDigestProvider").newInstance()));
            }
        }
        catch (Throwable throwable) {
            throw new SshException(throwable.getMessage() != null ? throwable.getMessage() : throwable.getClass().getName(), 5);
        }
    }

    private void A(String string, String string2) {
        try {
            Class<?> clazz = Class.forName(string2);
            this.b.add(string, clazz);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public int getMaximumPacketLength() {
        return this.f;
    }

    public void setMaximumPacketLength(int n) {
        if (n < 35000) {
            throw new IllegalArgumentException("The minimum packet length supported must be 35,000 bytes or greater!");
        }
        this.f = n;
    }

    public void setChannelLimit(int n) {
        this.S = n;
    }

    public int getChannelLimit() {
        return this.S;
    }

    public void setX11Display(String string) {
        this._ = string;
    }

    public String getX11Display() {
        return this._;
    }

    public byte[] getX11AuthenticationCookie() {
        if (this.d == null) {
            this.d = new byte[16];
            SecureRandom.getInstance().nextBytes(this.d);
        }
        return this.d;
    }

    public void setX11RealCookie(byte[] byArray) {
        this.R = byArray;
    }

    public byte[] getX11RealCookie() {
        if (this.R == null) {
            this.R = this.getX11AuthenticationCookie();
        }
        return this.R;
    }

    public void setX11RequestListener(ForwardingRequestListener forwardingRequestListener) {
        this.O = forwardingRequestListener;
    }

    public ForwardingRequestListener getX11RequestListener() {
        return this.O;
    }

    public BannerDisplay getBannerDisplay() {
        return this.U;
    }

    public void setBannerDisplay(BannerDisplay bannerDisplay) {
        this.U = bannerDisplay;
    }

    public AbstractComponentFactory supportedCiphers() {
        return this.b;
    }

    public String getPreferredCipherCS() {
        return this.L;
    }

    public void setPreferredCipherCS(String string) throws SshException {
        if (string == null) {
            return;
        }
        if (!this.b.contains(string)) {
            throw new SshException(string + " is not supported", 7);
        }
        this.L = string;
    }

    public String getPreferredCipherSC() {
        return this.e;
    }

    public void setPreferredCipherSC(String string) throws SshException {
        if (string == null) {
            return;
        }
        if (!this.b.contains(string)) {
            throw new SshException(string + " is not supported", 7);
        }
        this.e = string;
    }

    public AbstractComponentFactory supportedMacs() {
        return this.Q;
    }

    public String getPreferredMacCS() {
        return this.W;
    }

    public void setPreferredMacCS(String string) throws SshException {
        if (string == null) {
            return;
        }
        if (!this.Q.contains(string)) {
            throw new SshException(string + " is not supported", 7);
        }
        this.W = string;
    }

    public String getPreferredMacSC() {
        return this.P;
    }

    public void setPreferredMacSC(String string) throws SshException {
        if (string == null) {
            return;
        }
        if (!this.Q.contains(string)) {
            throw new SshException(string + " is not supported", 7);
        }
        this.P = string;
    }

    public AbstractComponentFactory supportedCompressions() {
        return this.c;
    }

    public String getPreferredCompressionCS() {
        return this.V;
    }

    public void setPreferredCompressionCS(String string) throws SshException {
        if (string == null) {
            return;
        }
        if (!this.c.contains(string)) {
            throw new SshException(string + " is not supported", 7);
        }
        this.V = string;
    }

    public String getPreferredCompressionSC() {
        return this.N;
    }

    public void setPreferredCompressionSC(String string) throws SshException {
        if (string == null) {
            return;
        }
        if (!this.c.contains(string)) {
            throw new SshException(string + " is not supported", 7);
        }
        this.N = string;
    }

    public AbstractComponentFactory supportedKeyExchanges() {
        return this.M;
    }

    public String getPreferredKeyExchange() {
        return this.Z;
    }

    public void setPreferredKeyExchange(String string) throws SshException {
        if (string == null) {
            return;
        }
        if (!this.M.contains(string)) {
            throw new SshException(string + " is not supported", 7);
        }
        this.Z = string;
    }

    public AbstractComponentFactory supportedPublicKeys() {
        return this.X;
    }

    public String getPreferredPublicKey() {
        return this.a;
    }

    public void setPreferredPublicKey(String string) throws SshException {
        if (string == null) {
            return;
        }
        if (!this.X.contains(string)) {
            throw new SshException(string + " is not supported", 7);
        }
        this.a = string;
    }

    public void setHostKeyVerification(HostKeyVerification hostKeyVerification) {
        this.K = hostKeyVerification;
    }

    public HostKeyVerification getHostKeyVerification() {
        return this.K;
    }

    public void setSFTPProvider(String string) {
        this.Y = string;
    }

    public String getSFTPProvider() {
        return this.Y;
    }
}

