/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.ssh2;

import com.maverick.crypto.io.ByteArrayReader;
import com.maverick.crypto.io.ByteArrayWriter;
import com.maverick.crypto.publickey.RsaKey;
import com.maverick.crypto.publickey.RsaPublicKey;
import com.maverick.ssh.SshException;
import com.maverick.ssh.SshKeyFingerprint;
import com.maverick.ssh.SshPublicKey;
import java.io.IOException;
import java.math.BigInteger;

public class Ssh2RsaPublicKey
extends RsaPublicKey
implements SshPublicKey {
    public Ssh2RsaPublicKey() {
    }

    public Ssh2RsaPublicKey(BigInteger bigInteger, BigInteger bigInteger2) {
        super(bigInteger, bigInteger2);
    }

    public byte[] getEncoded() throws SshException {
        try {
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byteArrayWriter.writeString(this.getAlgorithm());
            byteArrayWriter.writeBigInteger(this.getPublicExponent());
            byteArrayWriter.writeBigInteger(this.getModulus());
            return byteArrayWriter.toByteArray();
        }
        catch (IOException iOException) {
            throw new SshException(iOException.getMessage(), 5);
        }
    }

    public String getFingerprint() throws SshException {
        return SshKeyFingerprint.getFingerprint((byte[])this.getEncoded());
    }

    public void init(byte[] byArray, int n, int n2) throws SshException {
        try {
            ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
            String string = byteArrayReader.readString();
            if (!string.equals(this.getAlgorithm())) {
                throw new SshException("Invalid ssh-rsa key", 4);
            }
            this.publicExponent = byteArrayReader.readBigInteger();
            ((RsaKey)this).modulus = byteArrayReader.readBigInteger();
        }
        catch (IOException iOException) {
            throw new SshException(iOException.getMessage(), 5);
        }
    }

    public String getAlgorithm() {
        return "ssh-rsa";
    }

    public boolean verifySignature(byte[] byArray, byte[] byArray2) {
        try {
            ByteArrayReader byteArrayReader = new ByteArrayReader(byArray, 0, byArray.length);
            byte[] byArray3 = byteArrayReader.readBinaryString();
            String string = new String(byArray3);
            if (!string.equals(this.getAlgorithm())) {
                return false;
            }
            byArray = byteArrayReader.readBinaryString();
            return super.verifySignature(byArray, byArray2);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof Ssh2RsaPublicKey) {
            try {
                return ((Ssh2RsaPublicKey)((Object)object)).getFingerprint().equals(this.getFingerprint());
            }
            catch (SshException sshException) {
                // empty catch block
            }
        }
        return false;
    }

    public int hashCode() {
        try {
            return this.getFingerprint().hashCode();
        }
        catch (SshException sshException) {
            return 0;
        }
    }
}

