/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.ssh;

import com.maverick.ssh.Packet;
import com.maverick.ssh.SshChannel;
import com.maverick.ssh.SshException;
import com.maverick.ssh.SshIOException;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;

public class SubsystemChannel {
    DataInputStream B;
    DataOutputStream C;
    SshChannel D;
    Vector F = new Vector();
    _B A = new _B();
    _A E = new _A();

    public SubsystemChannel(SshChannel sshChannel) throws SshException {
        this.D = sshChannel;
        try {
            this.B = new DataInputStream(sshChannel.getInputStream());
            this.C = new DataOutputStream(sshChannel.getOutputStream());
        }
        catch (SshIOException sshIOException) {
            throw sshIOException.getRealException();
        }
        catch (IOException iOException) {
            throw new SshException(iOException.getMessage(), 6);
        }
    }

    public boolean isClosed() {
        return this.D.isClosed();
    }

    public void close() throws IOException {
        this.D.close();
    }

    public byte[] nextMessage() throws SshException {
        return this.A.A(this.B);
    }

    protected void sendMessage(Packet packet) throws SshException {
        this.E.A(packet);
    }

    protected void sendMessage(byte[] byArray) throws SshException {
        try {
            Packet packet = this.createPacket();
            ((OutputStream)((Object)packet)).write(byArray);
            this.sendMessage(byArray);
        }
        catch (IOException iOException) {
            throw new SshException(1, (Throwable)iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Packet createPacket() throws IOException {
        Vector vector = this.F;
        synchronized (vector) {
            if (this.F.size() == 0) {
                return new Packet();
            }
            Packet packet = (Packet)((Object)this.F.elementAt(0));
            this.F.removeElementAt(0);
            return packet;
        }
    }

    class _B {
        _B() {
        }

        synchronized byte[] A(DataInputStream dataInputStream) throws SshException {
            try {
                int n = dataInputStream.readInt();
                byte[] byArray = new byte[n];
                dataInputStream.readFully(byArray);
                return byArray;
            }
            catch (EOFException eOFException) {
                try {
                    SubsystemChannel.this.close();
                }
                catch (SshIOException sshIOException) {
                    throw sshIOException.getRealException();
                }
                catch (IOException iOException) {
                    throw new SshException(iOException.getMessage(), 6);
                }
                throw new SshException("The channel unexpectedly terminated", 6);
            }
            catch (IOException iOException) {
                try {
                    SubsystemChannel.this.close();
                }
                catch (SshIOException sshIOException) {
                    throw sshIOException.getRealException();
                }
                catch (IOException iOException2) {
                    throw new SshException(iOException2.getMessage(), 6);
                }
                throw new SshException("Unknown channel IO failure: " + iOException.getMessage(), 6);
            }
        }
    }

    class _A {
        _A() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        synchronized void A(Packet packet) throws SshException {
            Vector vector;
            try {
                try {
                    packet.finish();
                    SubsystemChannel.this.C.write(packet.array(), 0, ((ByteArrayOutputStream)((Object)packet)).size());
                }
                catch (SshIOException sshIOException) {
                    throw sshIOException.getRealException();
                }
                catch (EOFException eOFException) {
                    try {
                        SubsystemChannel.this.close();
                        throw new SshException("The channel unexpectedly terminated", 6);
                    }
                    catch (SshIOException sshIOException) {
                        throw sshIOException.getRealException();
                    }
                    catch (IOException iOException) {
                        throw new SshException(iOException.getMessage(), 6);
                    }
                }
                catch (IOException sshIOException) {
                    try {
                        SubsystemChannel.this.close();
                        throw new SshException("Unknown channel IO failure: " + sshIOException.getMessage(), 6);
                    }
                    catch (SshIOException sshIOException2) {
                        throw sshIOException2.getRealException();
                    }
                    catch (IOException iOException) {
                        throw new SshException(iOException.getMessage(), 6);
                    }
                }
                Object var5_2 = null;
                packet.reset();
                vector = SubsystemChannel.this.F;
            }
            catch (Throwable throwable) {
                Object var5_3 = null;
                packet.reset();
                Vector vector2 = SubsystemChannel.this.F;
                synchronized (vector2) {
                    SubsystemChannel.this.F.addElement(packet);
                    throw throwable;
                }
            }
            synchronized (vector) {
                SubsystemChannel.this.F.addElement(packet);
                return;
            }
        }
    }
}

