/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.dictionary.myspell;

import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import net.sf.retrotranslator.runtime.java.lang._Character;
import org.dts.spell.dictionary.myspell.AffixHeader;
import org.dts.spell.dictionary.myspell.AffixMgr;
import org.dts.spell.dictionary.myspell.Conditions;
import org.dts.spell.dictionary.myspell.Utils;

public abstract class AffEntry {
    protected AffixMgr pmyMgr;
    protected String appnd;
    protected String strip;
    protected short xpflg;
    protected char achar;
    Conditions conds;

    public AffEntry(AffixMgr pmyMgr, AffixHeader header, String line) throws IOException {
        this.pmyMgr = pmyMgr;
        this.xpflg = header.ff;
        this.achar = header.achar;
        this.readFrom(line, header.type);
        this.build_list();
    }

    public void readFrom(String line, char type) throws IOException {
        StringTokenizer tp = new StringTokenizer(line, " ");
        try {
            if (tp.nextToken().charAt(0) != type) {
                Utils.throwIOException("ERROR_AFFIX_HEADER_CORRUPT", new Object[]{_Character.valueOf((char)this.achar), line});
            }
            if (tp.nextToken().charAt(0) != this.achar) {
                Utils.throwIOException("ERROR_AFFIX_HEADER_CORRUPT", new Object[]{_Character.valueOf((char)this.achar), line});
            }
            this.strip = tp.nextToken();
            if (this.strip.equals("0")) {
                this.strip = "";
            }
            this.appnd = tp.nextToken();
            if (this.appnd.equals("0")) {
                this.appnd = "";
            }
            this.conds = this.createConditions(tp.nextToken());
        }
        catch (NoSuchElementException ex) {
            Utils.throwIOException("ERROR_AFFIX_HEADER_CORRUPT_COUNT", new Object[]{_Character.valueOf((char)this.achar), line});
        }
    }

    protected abstract Conditions createConditions(String var1);

    protected abstract void build_list();

    public char getName() {
        return this.achar;
    }
}

