/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.publickey;

import com.maverick.crypto.digests.Hash;
import com.maverick.crypto.io.ByteArrayReader;
import com.maverick.crypto.io.ByteArrayWriter;
import com.maverick.crypto.publickey.RsaPrivateCrtKey;
import com.maverick.crypto.security.SecureRandom;
import com.maverick.ssh.SshRsaPrivateCrtKey;
import com.maverick.ssh1.Ssh1RsaPublicKey;
import com.maverick.ssh1.SshDes3;
import com.sshtools.publickey.InvalidPassphraseException;
import com.sshtools.publickey.SshKeyPair;
import com.sshtools.publickey.SshPrivateKeyFile;
import java.io.IOException;
import java.math.BigInteger;

class D
implements SshPrivateKeyFile {
    public static final String D = "SSH PRIVATE KEY FILE FORMAT 1.1\n";
    String F;
    byte[] E;

    D(byte[] byArray) throws IOException {
        if (!com.sshtools.publickey.D.A(byArray)) {
            throw new IOException("SSH1 RSA Key required");
        }
        this.E = byArray;
    }

    D(SshKeyPair sshKeyPair, String string, String string2) throws IOException {
        this.E = this.A(sshKeyPair, string, string2);
    }

    public boolean supportsPassphraseChange() {
        return true;
    }

    public String getType() {
        return "SSH1";
    }

    public boolean isPassphraseProtected() {
        try {
            ByteArrayReader byteArrayReader = new ByteArrayReader(this.E);
            byte[] byArray = new byte[D.length()];
            byteArrayReader.read(byArray);
            String string = new String(byArray);
            byteArrayReader.read();
            if (!string.equals(D)) {
                return false;
            }
            int n = byteArrayReader.read();
            return n != 0;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public SshKeyPair toKeyPair(String string) throws IOException, InvalidPassphraseException {
        return this.A(this.E, string);
    }

    public static boolean A(byte[] byArray) {
        String string = new String(byArray);
        return string.startsWith(D.trim());
    }

    public SshKeyPair A(byte[] byArray, String string) throws IOException, InvalidPassphraseException {
        ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
        byte[] byArray2 = new byte[D.length()];
        byteArrayReader.read(byArray2);
        String string2 = new String(byArray2);
        byteArrayReader.read();
        if (!string2.equals(D)) {
            throw new IOException("RSA key file corrupt");
        }
        int n = byteArrayReader.read();
        if (n != 3 && n != 0) {
            throw new IOException("Private key cipher type is not supported!");
        }
        byteArrayReader.readInt();
        byteArrayReader.readInt();
        BigInteger bigInteger = byteArrayReader.readMPINT();
        BigInteger bigInteger2 = byteArrayReader.readMPINT();
        Ssh1RsaPublicKey ssh1RsaPublicKey = new Ssh1RsaPublicKey(bigInteger, bigInteger2);
        this.F = byteArrayReader.readString();
        byte[] byArray3 = new byte[8192];
        int n2 = byteArrayReader.read(byArray3);
        byte[] byArray4 = new byte[n2];
        System.arraycopy(byArray3, 0, byArray4, 0, n2);
        if (n == 3) {
            SshDes3 sshDes3 = new SshDes3();
            byte[] byArray5 = new byte[sshDes3.getBlockSize()];
            sshDes3.init(1, byArray5, this.A(string));
            sshDes3.transform(byArray4, 0, byArray4, 0, byArray4.length);
        }
        byteArrayReader = new ByteArrayReader(byArray4);
        byte by = (byte)byteArrayReader.read();
        byte by2 = (byte)byteArrayReader.read();
        byte by3 = (byte)byteArrayReader.read();
        byte by4 = (byte)byteArrayReader.read();
        if (by != by3 || by2 != by4) {
            throw new InvalidPassphraseException();
        }
        BigInteger bigInteger3 = byteArrayReader.readMPINT();
        BigInteger bigInteger4 = byteArrayReader.readMPINT();
        BigInteger bigInteger5 = byteArrayReader.readMPINT();
        BigInteger bigInteger6 = byteArrayReader.readMPINT();
        SshKeyPair sshKeyPair = new SshKeyPair();
        sshKeyPair.B = new SshRsaPrivateCrtKey(ssh1RsaPublicKey.getModulus(), ssh1RsaPublicKey.getPublicExponent(), bigInteger3, bigInteger5, bigInteger6, bigInteger4);
        sshKeyPair.A = ssh1RsaPublicKey;
        return sshKeyPair;
    }

    public byte[] A(SshKeyPair sshKeyPair, String string, String string2) throws IOException {
        if (sshKeyPair.getPrivateKey() instanceof RsaPrivateCrtKey) {
            RsaPrivateCrtKey rsaPrivateCrtKey = (RsaPrivateCrtKey)sshKeyPair.getPrivateKey();
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter(4096);
            byte[] byArray = new byte[2];
            SecureRandom secureRandom = SecureRandom.getInstance();
            secureRandom.nextBytes(byArray);
            byteArrayWriter.write(byArray[0]);
            byteArrayWriter.write(byArray[1]);
            byteArrayWriter.write(byArray[0]);
            byteArrayWriter.write(byArray[1]);
            byteArrayWriter.writeMPINT(rsaPrivateCrtKey.getPrivateExponent());
            byteArrayWriter.writeMPINT(rsaPrivateCrtKey.getCrtCoefficient());
            byteArrayWriter.writeMPINT(rsaPrivateCrtKey.getPrimeP());
            byteArrayWriter.writeMPINT(rsaPrivateCrtKey.getPrimeQ());
            byte[] byArray2 = byteArrayWriter.toByteArray();
            byArray = new byte[8 - byArray2.length % 8 + byArray2.length];
            System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
            byArray2 = byArray;
            int n = 3;
            SshDes3 sshDes3 = new SshDes3();
            byte[] byArray3 = new byte[sshDes3.getBlockSize()];
            sshDes3.init(0, byArray3, this.A(string));
            sshDes3.transform(byArray2, 0, byArray2, 0, byArray2.length);
            byteArrayWriter.reset();
            byteArrayWriter.write(D.getBytes());
            byteArrayWriter.write(0);
            byteArrayWriter.write(n);
            byteArrayWriter.writeInt(0);
            byteArrayWriter.writeInt(0);
            byteArrayWriter.writeMPINT(rsaPrivateCrtKey.getModulus());
            byteArrayWriter.writeMPINT(rsaPrivateCrtKey.getPublicExponent());
            byteArrayWriter.writeString(string2);
            byteArrayWriter.write(byArray2, 0, byArray2.length);
            return byteArrayWriter.toByteArray();
        }
        throw new IOException("RSA Private key required!");
    }

    public void changePassphrase(String string, String string2) throws IOException, InvalidPassphraseException {
        this.E = this.A(this.A(this.E, string), string2, this.F);
    }

    public byte[] getFormattedKey() {
        return this.E;
    }

    private byte[] A(String string) {
        Hash hash = new Hash("MD5");
        byte[] byArray = new byte[32];
        hash.putBytes(string.getBytes());
        byte[] byArray2 = hash.doFinal();
        System.arraycopy(byArray2, 0, byArray, 0, 16);
        System.arraycopy(byArray2, 0, byArray, 16, 16);
        return byArray;
    }
}

