/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.crypto.asn1;

import com.maverick.crypto.asn1.ASN1InputStream;
import com.maverick.crypto.asn1.DEREncodable;
import com.maverick.crypto.asn1.DERObject;
import com.maverick.crypto.asn1.DEROutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class DERApplicationSpecific
extends DERObject {
    private int w;
    private byte[] x;

    public DERApplicationSpecific(int n, byte[] byArray) {
        this.w = n;
        this.x = byArray;
    }

    public DERApplicationSpecific(int n, DEREncodable dEREncodable) throws IOException {
        this.w = n | 0x20;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
        dEROutputStream.writeObject(dEREncodable);
        this.x = byteArrayOutputStream.toByteArray();
    }

    public boolean isConstructed() {
        return (this.w & 0x20) != 0;
    }

    public byte[] getContents() {
        return this.x;
    }

    public int getApplicationTag() {
        return this.w & 0x1F;
    }

    public DERObject getObject() throws IOException {
        return new ASN1InputStream(new ByteArrayInputStream(this.getContents())).readObject();
    }

    void encode(DEROutputStream dEROutputStream) throws IOException {
        dEROutputStream.A(0x40 | this.w, this.x);
    }
}

