/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.crypto.asn1;

import com.maverick.crypto.asn1.ASN1OctetString;
import com.maverick.crypto.asn1.ASN1TaggedObject;
import com.maverick.crypto.asn1.DERObject;
import com.maverick.crypto.asn1.DEROutputStream;
import java.io.IOException;
import java.math.BigInteger;

public class DERInteger
extends DERObject {
    byte[] y;

    public static DERInteger getInstance(Object object) {
        if (object == null || object instanceof DERInteger) {
            return (DERInteger)object;
        }
        if (object instanceof ASN1OctetString) {
            return new DERInteger(((ASN1OctetString)object).getOctets());
        }
        if (object instanceof ASN1TaggedObject) {
            return DERInteger.getInstance(((ASN1TaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static DERInteger getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return DERInteger.getInstance(aSN1TaggedObject.getObject());
    }

    public DERInteger(int n) {
        this.y = BigInteger.valueOf(n).toByteArray();
    }

    public DERInteger(BigInteger bigInteger) {
        this.y = bigInteger.toByteArray();
    }

    public DERInteger(byte[] byArray) {
        this.y = byArray;
    }

    public BigInteger getValue() {
        return new BigInteger(this.y);
    }

    public BigInteger getPositiveValue() {
        return new BigInteger(1, this.y);
    }

    void encode(DEROutputStream dEROutputStream) throws IOException {
        dEROutputStream.A(2, this.y);
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i != this.y.length; ++i) {
            n ^= (this.y[i] & 0xFF) << i % 4;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof DERInteger)) {
            return false;
        }
        DERInteger dERInteger = (DERInteger)object;
        if (this.y.length != dERInteger.y.length) {
            return false;
        }
        for (int i = 0; i != this.y.length; ++i) {
            if (this.y[i] == dERInteger.y[i]) continue;
            return false;
        }
        return true;
    }
}

