/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.crypto.asn1;

import com.maverick.crypto.asn1.ASN1OctetString;
import com.maverick.crypto.asn1.ASN1TaggedObject;
import com.maverick.crypto.asn1.DERObject;
import com.maverick.crypto.asn1.DEROutputStream;
import com.maverick.crypto.asn1.DERString;
import java.io.IOException;

public class DERPrintableString
extends DERObject
implements DERString {
    String r;

    public static DERPrintableString getInstance(Object object) {
        if (object == null || object instanceof DERPrintableString) {
            return (DERPrintableString)object;
        }
        if (object instanceof ASN1OctetString) {
            return new DERPrintableString(((ASN1OctetString)object).getOctets());
        }
        if (object instanceof ASN1TaggedObject) {
            return DERPrintableString.getInstance(((ASN1TaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static DERPrintableString getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return DERPrintableString.getInstance(aSN1TaggedObject.getObject());
    }

    public DERPrintableString(byte[] byArray) {
        char[] cArray = new char[byArray.length];
        for (int i = 0; i != cArray.length; ++i) {
            cArray[i] = (char)(byArray[i] & 0xFF);
        }
        this.r = new String(cArray);
    }

    public DERPrintableString(String string) {
        this.r = string;
    }

    public String getString() {
        return this.r;
    }

    public byte[] getOctets() {
        char[] cArray = this.r.toCharArray();
        byte[] byArray = new byte[cArray.length];
        for (int i = 0; i != cArray.length; ++i) {
            byArray[i] = (byte)cArray[i];
        }
        return byArray;
    }

    void encode(DEROutputStream dEROutputStream) throws IOException {
        dEROutputStream.A(19, this.getOctets());
    }

    public int hashCode() {
        return this.getString().hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof DERPrintableString)) {
            return false;
        }
        DERPrintableString dERPrintableString = (DERPrintableString)object;
        return this.getString().equals(dERPrintableString.getString());
    }
}

