/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.crypto.asn1.x509;

import com.maverick.crypto.asn1.ASN1Encodable;
import com.maverick.crypto.asn1.ASN1EncodableVector;
import com.maverick.crypto.asn1.ASN1Sequence;
import com.maverick.crypto.asn1.ASN1TaggedObject;
import com.maverick.crypto.asn1.DEREncodable;
import com.maverick.crypto.asn1.DERObject;
import com.maverick.crypto.asn1.DERObjectIdentifier;
import com.maverick.crypto.asn1.DERSequence;

public class AlgorithmIdentifier
extends ASN1Encodable {
    private DERObjectIdentifier \u00c4;
    private DEREncodable \u00c6;
    private boolean \u00c5 = false;

    public static AlgorithmIdentifier getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return AlgorithmIdentifier.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static AlgorithmIdentifier getInstance(Object object) {
        if (object instanceof AlgorithmIdentifier) {
            return (AlgorithmIdentifier)object;
        }
        if (object instanceof DERObjectIdentifier) {
            return new AlgorithmIdentifier((DERObjectIdentifier)object);
        }
        if (object instanceof String) {
            return new AlgorithmIdentifier((String)object);
        }
        if (object instanceof ASN1Sequence) {
            return new AlgorithmIdentifier((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public AlgorithmIdentifier(DERObjectIdentifier dERObjectIdentifier) {
        this.\u00c4 = dERObjectIdentifier;
    }

    public AlgorithmIdentifier(String string) {
        this.\u00c4 = new DERObjectIdentifier(string);
    }

    public AlgorithmIdentifier(DERObjectIdentifier dERObjectIdentifier, DEREncodable dEREncodable) {
        this.\u00c5 = true;
        this.\u00c4 = dERObjectIdentifier;
        this.\u00c6 = dEREncodable;
    }

    public AlgorithmIdentifier(ASN1Sequence aSN1Sequence) {
        this.\u00c4 = (DERObjectIdentifier)aSN1Sequence.getObjectAt(0);
        if (aSN1Sequence.size() == 2) {
            this.\u00c5 = true;
            this.\u00c6 = aSN1Sequence.getObjectAt(1);
        } else {
            this.\u00c6 = null;
        }
    }

    public DERObjectIdentifier getObjectId() {
        return this.\u00c4;
    }

    public DEREncodable getParameters() {
        return this.\u00c6;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.\u00c4);
        if (this.\u00c5) {
            aSN1EncodableVector.add(this.\u00c6);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

