/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.crypto.publickey;

import com.maverick.crypto.digests.SHA1Digest;
import com.maverick.crypto.publickey.Dsa;
import com.maverick.crypto.publickey.DsaKey;
import java.math.BigInteger;

public class DsaPrivateKey
extends DsaKey {
    protected BigInteger x;

    public DsaPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        super(bigInteger, bigInteger2, bigInteger3);
        this.x = bigInteger4;
    }

    public BigInteger getX() {
        return this.x;
    }

    public byte[] sign(byte[] byArray) {
        SHA1Digest sHA1Digest = new SHA1Digest();
        sHA1Digest.update(byArray, 0, byArray.length);
        byte[] byArray2 = new byte[sHA1Digest.getDigestSize()];
        sHA1Digest.doFinal(byArray2, 0);
        return Dsa.sign(this.x, this.p, this.q, this.g, byArray2);
    }

    public boolean equals(Object object) {
        if (object instanceof DsaPrivateKey) {
            DsaPrivateKey dsaPrivateKey = (DsaPrivateKey)object;
            return this.x.equals(dsaPrivateKey.x) && this.p.equals(dsaPrivateKey.p) && this.q.equals(dsaPrivateKey.q) && this.g.equals(dsaPrivateKey.g);
        }
        return false;
    }
}

