/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.http;

import com.maverick.http.AuthenticationRequired;
import com.maverick.http.HttpAuthenticator;
import com.maverick.http.HttpClient;
import com.maverick.http.HttpConnection;
import com.maverick.http.HttpException;
import com.maverick.http.HttpMethod;
import com.maverick.http.HttpRequest;
import com.maverick.http.HttpResponse;
import com.maverick.http.SocketWithLayeredTransport;
import com.maverick.http.UnsupportedAuthenticationException;
import com.maverick.ssl.SSLTransport;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConnectMethod
extends HttpMethod {
    String hostname;
    int port;
    boolean targetIsSecure;
    HttpMethod toExecute;
    static Log log = LogFactory.getLog((Class)(class$com$maverick$http$ConnectMethod != null ? class$com$maverick$http$ConnectMethod : (class$com$maverick$http$ConnectMethod = ConnectMethod.class$("com.maverick.http.ConnectMethod"))));
    private static /* synthetic */ Class class$com$maverick$http$ConnectMethod;

    public HttpResponse execute(HttpClient httpClient, HttpConnection httpConnection) throws IOException, HttpException, AuthenticationRequired, UnsupportedAuthenticationException {
        boolean bl;
        HttpResponse httpResponse = this.execute(httpClient, new HttpRequest(this), httpConnection);
        String string = httpResponse.getHeaderField("Connection");
        boolean bl2 = bl = string != null && string.equalsIgnoreCase("close");
        if (!bl) {
            string = httpResponse.getHeaderField("proxy-connection");
            boolean bl3 = bl = string != null && string.equalsIgnoreCase("close");
        }
        if (httpResponse.getStatus() != 200) {
            if (httpResponse.getStatus() == 407) {
                throw new AuthenticationRequired(httpResponse.getHeaderField("proxy-authenticate"), "proxy-authenticate", "proxy-authorization", bl);
            }
            throw new HttpException(httpResponse.getReason(), httpResponse.getStatus());
        }
        return httpResponse;
    }

    public HttpResponse execute(HttpClient httpClient, HttpConnection httpConnection, HttpAuthenticator httpAuthenticator) throws IOException, HttpException, UnsupportedAuthenticationException {
        HttpRequest httpRequest = new HttpRequest(this);
        httpAuthenticator.authenticate(httpRequest, this.hostname + ":" + this.port);
        return this.execute(httpClient, httpRequest, httpConnection);
    }

    private HttpResponse execute(HttpClient httpClient, HttpRequest httpRequest, HttpConnection httpConnection) throws IOException, HttpException, UnsupportedAuthenticationException {
        httpRequest.setHeaderBegin("CONNECT " + this.hostname + ":" + this.port + " HTTP/1.1");
        httpRequest.setHeaderField("Host", httpConnection.getHost());
        httpRequest.setHeaderField("User-Agent", "Maverick-HttpClient/1.0");
        httpRequest.setHeaderField("Proxy-Connection", "Keep-Alive");
        OutputStream outputStream = httpConnection.getOutputStream();
        outputStream.write(httpRequest.toString().getBytes());
        outputStream.flush();
        HttpResponse httpResponse = new HttpResponse(httpConnection);
        log.info((Object)("HTTP CONNECT " + this.hostname + ":" + this.port + " returned " + httpResponse.getStatus() + " [" + httpResponse.getReason() + "]"));
        Enumeration enumeration = httpResponse.getHeaderFieldNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            log.info((Object)(string + ": " + httpResponse.getHeaderField(string)));
        }
        if (httpResponse.getStatus() == 200) {
            if (this.targetIsSecure) {
                ((SocketWithLayeredTransport)httpConnection.getSocket()).pushTransport(new SSLTransport());
            }
            if (this.toExecute != null) {
                httpConnection.setHost(this.hostname);
                httpConnection.setPort(this.port);
                return httpClient.execute(this.toExecute, httpConnection);
            }
        }
        return httpResponse;
    }

    public ConnectMethod(String string, int n, boolean bl, HttpMethod httpMethod) {
        super("CONNECT");
        this.hostname = string;
        this.port = n;
        this.targetIsSecure = bl;
        this.toExecute = httpMethod;
    }

    public ConnectMethod(String string, int n, boolean bl) {
        this(string, n, bl, null);
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

