/*
 * Decompiled with CFR 0.152.
 */
package com.sslexplorer.vpn.base;

import com.sslexplorer.vpn.base.AbstractVPNClient;
import com.sslexplorer.vpn.base.VPNTunnel;
import com.sslexplorer.vpn.base.VPNTunnelListener;
import com.sslexplorer.vpn.util.IOStreamConnector;
import com.sslexplorer.vpn.util.IOStreamConnectorListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VPNUDPTunnel
implements VPNTunnel {
    Socket tunnel;
    DatagramSocket socket;
    String destinationHost;
    int destinationPort;
    IOStreamConnector tx;
    IOStreamListener listener = new IOStreamListener();
    Vector listeners;
    IOStreamConnectorListener txListener;
    IOStreamConnectorListener rxListener;
    boolean listening;
    int packetSize = 65536;
    AbstractVPNClient vpn;
    int listeningPort;
    Log log = LogFactory.getLog((Class)(class$com$sslexplorer$vpn$base$VPNUDPTunnel != null ? class$com$sslexplorer$vpn$base$VPNUDPTunnel : (class$com$sslexplorer$vpn$base$VPNUDPTunnel = VPNUDPTunnel.class$("com.sslexplorer.vpn.base.VPNUDPTunnel"))));
    private static /* synthetic */ Class class$com$sslexplorer$vpn$base$VPNUDPTunnel;

    public void addListener(VPNTunnelListener vPNTunnelListener) {
        if (vPNTunnelListener != null) {
            this.listeners.addElement(vPNTunnelListener);
        }
    }

    public void stop() {
        this.listening = false;
        if (this.socket != null) {
            this.socket.close();
        }
        if (!this.tx.isClosed()) {
            this.tx.close();
        }
        int n = 0;
        while (n < this.listeners.size()) {
            ((VPNTunnelListener)this.listeners.elementAt(n)).stopped(this);
            ++n;
        }
    }

    VPNUDPTunnel(AbstractVPNClient abstractVPNClient, int n, Socket socket, DatagramSocket datagramSocket, String string, int n2, IOStreamConnectorListener iOStreamConnectorListener, IOStreamConnectorListener iOStreamConnectorListener2) {
        this.listeningPort = n;
        this.tunnel = socket;
        this.vpn = abstractVPNClient;
        this.destinationHost = string;
        this.socket = datagramSocket;
        this.destinationPort = n2;
        this.txListener = iOStreamConnectorListener;
        this.rxListener = iOStreamConnectorListener2;
        this.listeners = new Vector();
    }

    public String getDestinationHost() {
        return this.destinationHost;
    }

    public String getClientHost() {
        if (this.socket.getLocalAddress() == null) {
            return "localhost";
        }
        return this.socket.getLocalAddress().getHostName();
    }

    public void start() throws IOException {
        try {
            try {
                if (this.tunnel == null) {
                    throw new IOException("No tunnel has been initialised.");
                }
                if (this.socket == null) {
                    throw new IOException("No UPD socket has been initialised.");
                }
                InputStream inputStream = this.tunnel.getInputStream();
                OutputStream outputStream = this.tunnel.getOutputStream();
                if (inputStream == null || outputStream == null) {
                    throw new IOException("Either the input or output tunnel streams could not be obtained.");
                }
                DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
                final DataInputStream dataInputStream = new DataInputStream(inputStream);
                Thread thread = new Thread(this){
                    final /* synthetic */ VPNUDPTunnel this$0;
                    {
                        this.this$0 = vPNUDPTunnel;
                        this.this$0.getClass();
                    }

                    public void run() {
                        try {
                            try {
                                int n = -1;
                                while (true) {
                                    this.this$0.log.info((Object)"Waiting for source address / port from tunnel");
                                    byte[] byArray = new byte[4];
                                    dataInputStream.read(byArray);
                                    InetAddress inetAddress = InetAddress.getByName(new Byte(byArray[0]).intValue() + "." + new Byte(byArray[1]).intValue() + "." + new Byte(byArray[2]).intValue() + "." + new Byte(byArray[3]).intValue());
                                    int n2 = dataInputStream.readInt();
                                    int n3 = dataInputStream.readInt();
                                    this.this$0.log.info((Object)("Source is " + inetAddress + ":" + n2 + " packet port:" + n3));
                                    this.this$0.log.info((Object)"Waiting for packet size from tunnel");
                                    n = dataInputStream.readInt();
                                    this.this$0.log.info((Object)("Got packet size - expecting " + n + " bytes"));
                                    byte[] byArray2 = new byte[n];
                                    dataInputStream.readFully(byArray2);
                                    DatagramPacket datagramPacket = new DatagramPacket(byArray2, n, inetAddress, n2);
                                    this.this$0.log.info((Object)("Tunneling " + n + " UDP bytes to " + inetAddress + " / " + n2 + " [" + new String(byArray2)));
                                    this.this$0.socket.send(datagramPacket);
                                    this.this$0.listener.dataTransfered(byArray2, n);
                                    if (this.this$0.rxListener == null) continue;
                                    this.this$0.rxListener.dataTransfered(byArray2, n);
                                }
                            }
                            catch (EOFException eOFException) {
                            }
                            catch (Exception exception) {
                                this.this$0.log.error((Object)"Error reading tunnel.", (Throwable)exception);
                            }
                            Object var9_9 = null;
                            this.this$0.listener.connectorClosed(null);
                            if (this.this$0.rxListener != null) {
                                this.this$0.rxListener.connectorClosed(null);
                            }
                        }
                        catch (Throwable throwable) {
                            Object var9_10 = null;
                            this.this$0.listener.connectorClosed(null);
                            if (this.this$0.rxListener != null) {
                                this.this$0.rxListener.connectorClosed(null);
                            }
                            throw throwable;
                        }
                    }
                };
                thread.start();
                int n = 0;
                while (n < this.listeners.size()) {
                    ((VPNTunnelListener)this.listeners.elementAt(n)).started(this);
                    ++n;
                }
                this.listening = true;
                byte[] byArray = new byte[this.packetSize];
                DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
                while (this.listening) {
                    datagramPacket.setData(byArray);
                    datagramPacket.setLength(byArray.length);
                    this.log.info((Object)"Waiting for UDP packet");
                    this.socket.receive(datagramPacket);
                    this.log.info((Object)("Got UDP packet of " + datagramPacket.getLength()));
                    InetAddress inetAddress = datagramPacket.getAddress();
                    int n2 = datagramPacket.getPort();
                    this.log.info((Object)("Address is " + inetAddress + ":" + n2));
                    dataOutputStream.write(inetAddress.getAddress());
                    dataOutputStream.writeInt(n2);
                    dataOutputStream.writeInt(datagramPacket.getLength());
                    this.log.info((Object)("Writing UDP packet of " + datagramPacket.getLength() + " bytes back to the tunnel [" + new String(datagramPacket.getData(), 0, datagramPacket.getLength())));
                    dataOutputStream.write(datagramPacket.getData(), 0, datagramPacket.getLength());
                    this.log.info((Object)"Flushed");
                    dataOutputStream.flush();
                    this.listener.dataTransfered(byArray, datagramPacket.getLength());
                    if (this.rxListener == null) continue;
                    this.rxListener.dataTransfered(byArray, datagramPacket.getLength());
                }
            }
            catch (Throwable throwable) {
                this.log.error((Object)"Failed to start UDP tunnel.", throwable);
                throw new IOException("The tunnel failed to start: " + throwable.getMessage());
            }
            Object var11_12 = null;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            try {
                this.log.info((Object)"Closing UDP socket");
                this.socket.close();
            }
            catch (Exception exception) {}
            try {
                this.log.info((Object)"Closing UDP tunnel");
                this.tunnel.close();
            }
            catch (Exception exception) {}
            this.listener.connectorClosed(null);
            if (this.txListener != null) {
                this.txListener.connectorClosed(null);
            }
            throw throwable;
        }
        try {
            this.log.info((Object)"Closing UDP socket");
            this.socket.close();
        }
        catch (Exception exception) {}
        try {
            this.log.info((Object)"Closing UDP tunnel");
            this.tunnel.close();
        }
        catch (Exception exception) {}
        this.listener.connectorClosed(null);
        if (this.txListener != null) {
            this.txListener.connectorClosed(null);
        }
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public int getDestinationPort() {
        return this.destinationPort;
    }

    class IOStreamListener
    implements IOStreamConnectorListener {
        boolean hasStopped;

        IOStreamListener() {
            VPNUDPTunnel.this.getClass();
            this.hasStopped = false;
        }

        public synchronized void connectorClosed(IOStreamConnector iOStreamConnector) {
            VPNUDPTunnel.this.log.info((Object)"Connector closed");
            VPNUDPTunnel.this.socket.close();
            try {
                VPNUDPTunnel.this.tunnel.close();
            }
            catch (Exception exception) {}
            if (!this.hasStopped) {
                VPNUDPTunnel.this.stop();
                this.hasStopped = true;
            }
        }

        public void dataTransfered(byte[] byArray, int n) {
            int n2 = VPNUDPTunnel.this.listeners.size() - 1;
            while (n2 >= 0) {
                ((VPNTunnelListener)VPNUDPTunnel.this.listeners.elementAt(n2)).dataTransferred(VPNUDPTunnel.this, byArray, n);
                --n2;
            }
        }
    }
}

