/*****************************************************************************
 * Sun Public License Notice
 *
 * The contents of this file are subject to the Sun Public License Version
 * 1.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is available at http://www.sun.com/
 *
 * The Original Code is the CVS Client Library.
 * The Initial Developer of the Original Code is Thomas Singer.
 * Portions created by Robert Greig are Copyright (C) 2001.
 * All Rights Reserved.
 *
 * Contributor(s): Thomas Singer.
 *****************************************************************************/
package org.netbeans.lib.cvsclient.command;

import java.util.*;

import org.netbeans.lib.cvsclient.file.*;

/**
 * @author Thomas Singer
 */
public final class CommandUtils {

	/**
	 * Returns the directory relative to local path from the specified message.
	 * This method returns null, if the specified message isn't a EXAM_DIR-
	 * message.
	 */
	public static String getExaminedDirectory(String message, String examDirPattern) {
		final int index = message.indexOf(examDirPattern);
		if (index < 0) {
			return null;
		}

		return message.substring(index + examDirPattern.length());
	}

	public static String getMessageNotNull(String message) {
		if (message != null) {
			message = message.trim();
		}
		if (message == null || message.length() == 0) {
			message = "no message";
		}
		return message;
	}

	public static void appendFileArguments(Collection<? extends FsPath> fsPaths, StringBuilder buffer) {
		int count = 0;
		for (final FsPath fsEntry : fsPaths) {
			if (count > 0) {
				buffer.append(' ');
			}
			if (count > 20) {
				buffer.append("...");
				break;
			}

			count++;

			buffer.append(FileUtils.toUnixPath(fsEntry, true));
		}
	}

	/**
	 * Returns the trimmed version of the specified String s.
	 * The returned String is null if the specified String is null or contains
	 * only white spaces.
	 */
	public static String getTrimmedString(String s) {
		if (s == null) {
			return null;
		}

		s = s.trim();
		if (s.length() == 0) {
			return null;
		}

		return s;
	}
}
