/*
 *                 Sun Public License Notice
 *
 * The contents of this file are subject to the Sun Public License
 * Version 1.0 (the "License"). You may not use this file except in
 * compliance with the License. A copy of the License is available at
 * http://www.sun.com/
 *
 * The Original Code is NetBeans. The Initial Developer of the Original
 * Code is Sun Microsystems, Inc. Portions Copyright 1997-2000 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.lib.cvsclient.command;

import java.io.*;

import org.netbeans.lib.cvsclient.file.*;
import org.netbeans.lib.cvsclient.util.*;

/**
 * @author Thomas Singer
 */
public final class DefaultFileInfo
		implements IFileInfo {

	// Fields =================================================================

	private final FsFilePath fsFile;
	private final File file;

	// Setup ==================================================================

	public DefaultFileInfo(FsFilePath fsFile, File file) {
		BugLog.assertNotNull(fsFile);
		BugLog.assertNotNull(file);

		this.fsFile = fsFile;
		this.file = file;
	}

	// Implemented ============================================================

	public FsFilePath getFsFile() {
		return fsFile;
	}

	@Override
	public String toString() {
		final StringBuffer buffer = new StringBuffer();
		if (file.isDirectory()) {
			buffer.append("Directory ");
		}
		buffer.append(file.getAbsolutePath());
		return buffer.toString();
	}

	// Accessing ==============================================================

	public File getFile() {
		return file;
	}
}
