/*
 *                 Sun Public License Notice
 *
 * The contents of this file are subject to the Sun Public License
 * Version 1.0 (the "License"). You may not use this file except in
 * compliance with the License. A copy of the License is available at
 * http://www.sun.com/
 *
 * The Original Code is NetBeans. The Initial Developer of the Original
 * Code is Thomas Singer. All Rights Reserved.
 */
package org.netbeans.lib.cvsclient.command.reservedcheckout;

import java.io.*;
import java.util.*;

import org.netbeans.lib.cvsclient.*;
import org.netbeans.lib.cvsclient.command.*;
import org.netbeans.lib.cvsclient.event.*;
import org.netbeans.lib.cvsclient.file.*;
import org.netbeans.lib.cvsclient.progress.*;
import org.netbeans.lib.cvsclient.progress.sending.*;

/**
 * @author Thomas Singer
 */
public final class UneditCommand extends AbstractCommand {

	// Static =================================================================

	public static boolean executeUnedit(ICvsFiles cvsFiles, Watch temporaryWatch, IClientEnvironment clientEnvironment, IProgressViewer progressViewer, IRequestProcessor requestProcessor,
	                                    AbstractCommand command) throws CommandException {
		final IRequestsProgressHandler requestsProgressHandler = new FileStateRequestsProgressHandler(new RangeProgressViewer(progressViewer, 0.0, 0.8), cvsFiles);
		return requestProcessor.communicateWithServer(new UneditRequestFactory(cvsFiles, temporaryWatch),
		                                              requestsProgressHandler, clientEnvironment, command.getGlobalOptions());
	}

	public static UneditCommand createUneditCommand(FsDirectoryPath fsDirectory) {
		return new UneditCommand(Collections.singleton(fsDirectory));
	}

	public static UneditCommand createUneditCommand(Collection<FsFilePath> fsFiles) {
		return new UneditCommand(fsFiles);
	}

	// Fields =================================================================

	private final Collection<? extends FsPath> fsPaths;
	private boolean recursive = true;
	private Watch temporaryWatch;

	// Setup ==================================================================

	private UneditCommand(Collection<? extends FsPath> fsPaths) {
		this.fsPaths = fsPaths;
		setRecursive(true);
	}

	// Implemented ============================================================

	@Override
	public boolean execute(IRequestProcessor requestProcessor, IEventSender eventSender, ICvsListenerRegistry listenerRegistry, IClientEnvironment clientEnvironment, IProgressViewer progressViewer) throws CommandException {
		final ICvsFiles cvsFiles;
		try {
			cvsFiles = FileSystemScanner.scan(fsPaths, recursive, clientEnvironment);
		}
		catch (IOException ex) {
			throw new IOCommandException(ex);
		}

		return executeUnedit(cvsFiles, this.temporaryWatch, clientEnvironment, progressViewer, requestProcessor, this);
	}

	@Override
	public String getCvsCommandLine() {
		final StringBuilder cvsCommandLine = new StringBuilder("unedit ");
		if (!recursive) {
			cvsCommandLine.append("-l ");
		}
		CommandUtils.appendFileArguments(fsPaths, cvsCommandLine);
		return cvsCommandLine.toString();
	}

	// Accessing ==============================================================

	public void setTemporaryWatch(Watch temporaryWatch) {
		this.temporaryWatch = temporaryWatch;
	}

	public void setRecursive(boolean recursive) {
		this.recursive = recursive;
	}
}
