/*
 *                 Sun Public License Notice
 *
 * The contents of this file are subject to the Sun Public License
 * Version 1.0 (the "License"). You may not use this file except in
 * compliance with the License. A copy of the License is available at
 * http://www.sun.com/
 *
 * The Original Code is NetBeans. The Initial Developer of the Original
 * Code is Thomas Singer. All Rights Reserved.
 */
package org.netbeans.lib.cvsclient.command.reservedcheckout;

import java.io.*;

import org.netbeans.lib.cvsclient.*;
import org.netbeans.lib.cvsclient.admin.*;
import org.netbeans.lib.cvsclient.command.*;
import org.netbeans.lib.cvsclient.file.*;
import org.netbeans.lib.cvsclient.request.*;
import org.netbeans.lib.cvsclient.util.*;

/**
 * @author Thomas Singer
 */
public final class UneditRequestFactory extends AbstractRequestFactory implements ICommandRequestFactory {

	// Fields =================================================================

	private final ICvsFiles cvsFiles;
	private final Watch temporaryWatch;

	// Setup ==================================================================

	public UneditRequestFactory(ICvsFiles cvsFiles, Watch temporaryWatch) {
		this.cvsFiles = cvsFiles;
		this.temporaryWatch = temporaryWatch;
	}

	// Implemented ============================================================

	public ResponseExpectingRequest getResponseExpectingRequest() {
		return CommandRequest.NOOP;
	}

	public void sendCommandRequests(IRequestSender requestSender, IClientEnvironment clientEnvironment) throws CommandAbortedException, IOException {
		Requests.addArgumentRequest("--", requestSender);
		addFileAndLocalPathRequests(cvsFiles, IgnoreFileFilter.IGNORE_ALL, clientEnvironment, requestSender);
	}

	@Override
	protected void addRequestForFile(FsFilePath fsFile, Entry entry, boolean fileExists, IIgnoreFileFilter ignoreFileFilter, IClientEnvironment clientEnvironment, IRequestSender requestSender) throws CommandAbortedException, IOException {
		if (!fileExists || entry == null) {
			return;
		}

		Requests.addNotifyRequest(fsFile, clientEnvironment.getLocalFileSystem(), "U", Watch.getWatchString(temporaryWatch), requestSender);

		clientEnvironment.getAdminWriter().uneditFile(fsFile);
	}
}
