/*
 *                 Sun Public License Notice
 *
 * The contents of this file are subject to the Sun Public License
 * Version 1.0 (the "License"). You may not use this file except in
 * compliance with the License. A copy of the License is available at
 * http://www.sun.com/
 *
 * The Original Code is NetBeans. The Initial Developer of the Original
 * Code is Sun Microsystems, Inc. Portions Copyright 1997-2000 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.lib.cvsclient.connection;

/**
 * @author Thomas Singer
 */
public final class SolveableAuthenticationException extends AuthenticationException {

	// Constants ==============================================================

	public static final Id PRIVATE_KEY_FILE = new Id("PRIVATE_KEY_FILE");
	public static final Id PASSPHRASE = new Id("PASSPHRASE");
	public static final Id PASSWORD = new Id("PASSWORD");

	// Fields =================================================================

	private final Id id;

	// Setup ==================================================================

	public SolveableAuthenticationException(String message) {
		this(message, null);
	}

	public SolveableAuthenticationException(String message, Id id) {
		super(message);
		this.id = id;
	}

	// Accessing ==============================================================

	public Id getId() {
		return id;
	}

	// Inner classes ==========================================================

	public static final class Id {

		private final String name;

		private Id(String name) {
			this.name = name;
		}

		@Override
		public String toString() {
			return name;
		}
	}
}
