package org.netbeans.lib.cvsclient.io;

import java.io.*;

/**
 * @author Thomas Singer
 */
public final class ByteBufferInputStream extends InputStream {

	// Fields =================================================================

	private final byte[] buffer;
	private int nextIndex;

	// Setup ==================================================================

	public ByteBufferInputStream(int[] values) {
		buffer = new byte[values.length];
		for (int i = 0; i < values.length; i++) {
			final int value = values[i];
			buffer[i] = (byte)value;
		}
	}

	// Implemented ============================================================

	@Override
	public int read() {
		if (nextIndex >= buffer.length) {
			return -1;
		}

		return buffer[nextIndex++] & 0xFF;
	}
}
