package org.netbeans.lib.cvsclient.progress.receiving;

import org.netbeans.lib.cvsclient.command.*;
import org.netbeans.lib.cvsclient.event.*;
import org.netbeans.lib.cvsclient.file.*;
import org.netbeans.lib.cvsclient.progress.*;

/**
 * @author Thomas Singer
 */
public final class FileInfoAndDirectoryResponseProgressHandler
		implements ICvsListener, IDirectoryListener, IFileInfoListener {

	// Fields =================================================================

	private final ResponseProgressHandler responseProgressHandler;

	// Setup ==================================================================

	public static ICvsListener createInstance(IProgressViewer progressViewer, ICvsFiles cvsFiles) {
		return new FileInfoAndDirectoryResponseProgressHandler(progressViewer, cvsFiles);
	}

	private FileInfoAndDirectoryResponseProgressHandler(IProgressViewer progressViewer, ICvsFiles cvsFiles) {
		responseProgressHandler = new ResponseProgressHandler(progressViewer, ResponseProgressHandler.getFsFiles(cvsFiles));
	}

	// Implemented ============================================================

	public void registerListeners(ICvsListenerRegistry listenerRegistry) {
		listenerRegistry.addDirectoryListener(this);
		listenerRegistry.addFileInfoListener(this);
	}

	public void unregisterListeners(ICvsListenerRegistry listenerRegistry) {
		listenerRegistry.removeDirectoryListener(this);
		listenerRegistry.removeFileInfoListener(this);
	}

	public void processingDirectory(FsDirectoryPath directoryPath) {
		responseProgressHandler.directoryProcessed(directoryPath);
	}

	public void fileInfoGenerated(Object info) {
		if (info instanceof IFileInfo) {
			final IFileInfo fileInfo = (IFileInfo)info;
			responseProgressHandler.fileProcessed(fileInfo.getFsFile());
		}
	}
}
