package org.netbeans.lib.cvsclient.request;

import java.text.*;
import java.util.*;

import org.netbeans.lib.cvsclient.util.*;

/**
 * @author Thomas Singer
 */
final class CheckinTimeRequest extends AbstractRequest {

	// Static =================================================================

	private static DateFormat format;

	private static synchronized String format(Date date) {
		if (format == null) {
			format = new SimpleDateFormat("dd MMM yyyy hh:mm:ss z", Locale.US);
		}
		return format.format(date);
	}

	// Fields =================================================================

	private final Date date;

	// Setup ==================================================================

	public CheckinTimeRequest(Date date) {
		BugLog.assertNotNull(date);
		this.date = date;
	}

	// Implemented ============================================================

	/**
	 * A valid date format looks like this: "29 Jun 2004 15:19:33 -0000" (taken from CVSNT).
	 */
	public String getRequestString() {
		return "Checkin-time " + format(date) + '\n';
	}
}