package org.netbeans.lib.cvsclient.request;

import org.netbeans.lib.cvsclient.util.*;

/**
 * @author Thomas Singer
 */
public final class ClientVersionRequest extends AbstractRequest {

	// Constants ==============================================================

	public static final String REQUEST = "client-version";

	// Fields =================================================================

	private final String clientVersion;

	// Setup ==================================================================

	public ClientVersionRequest(String clientVersion) {
		BugLog.assertNotNull(clientVersion);
		BugLog.assertTrue(clientVersion.trim().length() > 0 && clientVersion.indexOf('\n') < 0, "invalid client version");

		this.clientVersion = clientVersion;
	}

	// Implemented ============================================================

	public String getRequestString() {
		return REQUEST + ' ' + clientVersion + '\n';
	}
}
