package org.netbeans.lib.cvsclient.response;

import java.io.*;
import java.util.*;

import org.netbeans.lib.cvsclient.*;

/**
 * @author Thomas Singer
 */
public interface IResponseHandler {

	void processErrorMessageResponse(String message);

	void processMessageResponse(String message);

	void processMessageTaggedResponse(String message);

	void processCheckedInResponse(String relativeLocalDirectory, String repositoryFilePath, String entryLine) throws IOException;

	void processNewEntryResponse(String relativeLocalDirectory, String repositoryFilePath, String entryLine) throws IOException;

	void processSetStaticDirectoryResponse(String relativeLocalDirectory, String repositoryFilePath) throws IOException;

	void processClearStaticDirectoryResponse(String relativeLocalDirectory, String repositoryDirectoryPath) throws IOException;

	void processSetStickyResponse(String relativeLocalDirectory, String repositoryFilePath, String tag) throws IOException;

	void processClearStickyResponse(String relativeLocalDirectory, String repositoryFilePath) throws IOException;

	void processNotifiedResponse(String relativeLocalDirectory, String repositoryFilePath);

	void processRemovedResponse(String relativeLocalDirectory, String repositoryFilePath) throws IOException;

	void processRemoveEntryResponse(String relativeLocalDirectory, String repositoryFilePath) throws IOException;

	void processCopyFileResponse(String relativeLocalDirectory, String repositoryFilePath, String newName) throws IOException;

	void processModTimeResponse(Date modifiedDate);

	void processModeResponse(String mode);

	void processTemplateResponse(String relativeLocalDirectory, String repositoryFilePath, int length, IConnectionStreams connectionStreams) throws IOException;

	void processModuleExpansionResponse(String localPath);

	void processOkResponse();

	void processErrorResponse(String message);

	void processUpdatedResponse(String relativeLocalDirectory, String repositoryFilePath, String entryLine, String mode, int fileLength, IConnectionStreams connectionStreams) throws IOException;

	void processMergedResponse(String relativeLocalDirectory, String repositoryFilePath, String entryLine, String mode, int fileLength, IConnectionStreams connectionStreams) throws IOException;

	void processValidRequestsResponse(String validRequests);
}
