/*
 *                 Sun Public License Notice
 *
 * The contents of this file are subject to the Sun Public License
 * Version 1.0 (the "License"). You may not use this file except in
 * compliance with the License. A copy of the License is available at
 * http://www.sun.com/
 *
 * The Original Code is NetBeans. The Initial Developer of the Original
 * Code is Sun Microsystems, Inc. Portions Copyright 1997-2000 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.lib.cvsclient.util;

/**
 * @author Thomas Singer
 */
public final class BugLog {

	// Static =================================================================

	public static void assertTrue(boolean value) {
		assertTrue(value, "");
	}

	public static void assertTrue(boolean value, String message) {
		if (value) {
			return;
		}

		assertationFailed(message);
	}

	public static void assertNotNull(Object obj) {
		if (obj != null) {
			return;
		}

		assertationFailed("Value must not be null!");
	}

	public static void assertationFailed(String message) {
		throw new BugException(message);
	}

	// Inner Classes ==========================================================

	private static final class BugException extends RuntimeException {
		private BugException(String message) {
			super(message);
		}
	}
}
