create database SMTPAnalyzer;

go
--Replace <enterStrongPasswordHere> with the password you'd like the new login to have
--Be sure to keep the single quotes around the password
CREATE LOGIN SMTPAnalyzer WITH PASSWORD = '<enterStrongPasswordHere>';

use SMTPAnalyzer;
CREATE USER SMTPAnalyzer FOR LOGIN SMTPAnalyzer;
go

create table SMTPLog (
	MessageID varchar(100) not null,
	MessageTime datetime not null,
	ArrivalTime datetime not null,
	FromAddr varchar(200),
	ToAddr varchar(300),
	Subject varchar(200),
	ApproxSizeBytes int,
	IncomingServerIP varchar(15),
	Headers text
)

alter table smtplog add constraint SMTPLog_PK primary key nonclustered (MessageID, MessageTime);


create table DeliveryDetails (
	MessageID varchar(100) not null,
	MessageTime datetime not null,
	TransmissionTime datetime default (getdate()),
	Recipient varchar(50),
	OutgoingServerIP varchar(15),
	DeliveryStatus varchar(50),
	DeliveryNotes varchar(500)
)

alter table deliverydetails add constraint DeliveryDetails_SMTPLog_FK foreign key (MessageID, MessageTime) references SMTPLog
create index DeliveryDetails_MessageIDTime_idx on deliverydetails(messageid, messagetime);


grant select, insert, update on smtplog to smtpanalyzer;
grant select, insert, update on deliverydetails to smtpanalyzer;

--SMTP Analyzer version 1.0 database creation script
--Copyright 2008, Wendt Enterprises, LLC