unit DriveSpace;

interface

uses Windows,Messages,SysUtils,Variants,Classes,
     Graphics,Controls,Forms,Dialogs,OleCtrls,StdCtrls,
     ComCtrls;

type TfrmDriveSpace = class(TForm)
       lvSpace: TListView;
       procedure FormActivate(Sender: TObject);
       procedure FormKeyPress(Sender: TObject; var Key: Char);
     private
     public
     end;

var frmDriveSpace : TfrmDriveSpace;

implementation

{$R *.dfm}

uses VPAExt;

procedure TfrmDriveSpace.FormActivate(Sender: TObject);

var n,pctFree,pctUsed : integer;
    nFree,nUsed,nTotal,
    nGFree,nGUsed,nGTotal : int64;
    i : TListItem;

begin
  lvSpace.Items.Clear;
  nGFree := 0;
  nGUsed := 0;
  nGTotal := 0;

  for n := 1 to 26 do
  begin
    nFree := DiskFree(n);

    if nFree <> -1 then
    begin
      nTotal := DiskSize(n);
      nUsed := nTotal - nFree;
      nGFree := nGFree + nFree;
      nGTotal := nGTotal + nTotal;
      nGUsed := nGTotal - nGFree;
      pctUsed := Round((nTotal - nFree) / nTotal * 100);
      pctFree := 100 - pctUsed;
      i := lvSpace.Items.Add;
      i.Caption := Chr(n + 64) + ':';
      i.SubItems.Add(FileSizeText(nTotal));
      i.SubItems.Add(FileSizeText(nUsed) + ' (' + IntToStr(pctUsed) + '%)');
      i.SubItems.Add(FileSizeText(nFree) + ' (' + IntToStr(pctFree) + '%)');
    end;
  end;

  pctUsed := Round((nGTotal - nGFree) / nGTotal * 100);
  pctFree := 100 - pctUsed;
  i := lvSpace.Items.Add;
  i.Caption := 'All';
  i.SubItems.Add(FileSizeText(nGTotal));
  i.SubItems.Add(FileSizeText(nGUsed) + ' (' + IntToStr(pctUsed) + '%)');
  i.SubItems.Add(FileSizeText(nGFree) + ' (' + IntToStr(pctFree) + '%)');
  Caption := 'Drive Space';
end;

procedure TfrmDriveSpace.FormKeyPress(Sender: TObject; var Key: Char);
begin
  if Key = ESC then Close;
end;

end.
