unit EditProps;

interface

uses Windows,Messages,SysUtils,Variants,Classes,
     Graphics,Controls,Forms,Dialogs,StdCtrls,ExtCtrls;

type TfrmEditProps = class(TForm)
       pnlSrc: TPanel;
       pnlMode: TPanel;
       pnlTrg: TPanel;
       lblSrc: TLabel;
       edtSrc: TEdit;
       lblTrg: TLabel;
       edtTrg: TEdit;
       pnlSpec: TPanel;
       pnlTrgRoot: TPanel;
       pnlCmd: TPanel;
       lblTrgRoot: TLabel;
       edtTrgRoot: TEdit;
       lblSpec: TLabel;
       edtSpec: TEdit;
       lblMode: TLabel;
       cmbMode: TComboBox;
       cmdOk: TButton;
       cmdCancel: TButton;
       chkSub: TCheckBox;
       dlgOpen: TOpenDialog;
       procedure cmdOkClick(Sender: TObject);
       procedure cmdCancelClick(Sender: TObject);
       procedure FormKeyPress(Sender: TObject; var Key: Char);
       procedure edtSrcExit(Sender: TObject);
       procedure edtTrgExit(Sender: TObject);
       procedure FormActivate(Sender: TObject);
       procedure lblSrcDblClick(Sender: TObject);
       procedure lblSpecDblClick(Sender: TObject);
       procedure lblTrgDblClick(Sender: TObject);
       procedure edtSrcChange(Sender: TObject);
     private
       procedure SetTrgRootHint;
     public
       RetVal : byte;
     end;

var frmEditProps : TfrmEditProps;

implementation

{$R *.dfm}

uses VPAExt,Main;

procedure TfrmEditProps.FormActivate(Sender: TObject);
begin
  RetVal := 0;
  SetTrgRootHint;
end;

procedure TfrmEditProps.FormKeyPress(Sender: TObject; var Key: Char);
begin
  if Key = #27 then Close;
end;

procedure TfrmEditProps.cmdOkClick(Sender: TObject);
begin
  RetVal := 1;
  Close;
end;

procedure TfrmEditProps.cmdCancelClick(Sender: TObject);
begin
  Close;
end;

procedure TfrmEditProps.lblSpecDblClick(Sender: TObject);
begin
  dlgOpen.InitialDir := edtSrc.Text;

  if dlgOpen.Execute then
    edtSpec.Text := ExtractFilename(dlgOpen.Filename);
end;

procedure TfrmEditProps.lblSrcDblClick(Sender: TObject);

var Src : string;

begin
  Src := GetDirectory(c_App + ' - SOURCE Folder');
  if Src = '' then exit;
  edtSrc.Text := FinalBS(Src);
  edtTrgRoot.Text := LastDir(Src);
end;

procedure TfrmEditProps.lblTrgDblClick(Sender: TObject);

var Trg : string;

begin
  Trg := GetDirectory(c_App + ' - TARGET Folder');
  if Trg <> '' then edtTrg.Text := FinalBS(Trg);
end;

procedure TfrmEditProps.edtSrcChange(Sender: TObject);
begin
  SetTrgRootHint;
end;

procedure TfrmEditProps.edtSrcExit(Sender: TObject);
begin
  edtSrc.Text := FinalBS(edtSrc.Text);
end;

procedure TfrmEditProps.edtTrgExit(Sender: TObject);
begin
  edtTrg.Text := FinalBS(edtTrg.Text);
end;

procedure TfrmEditProps.SetTrgRootHint;
begin
  edtTrgRoot.Hint :=
   'Leave blank for default (' +
   LastDir(edtSrc.Text) + ') or use \ for volume root';
end;

end.
