unit FileHash;

interface

uses Windows,Messages,SysUtils,Variants,Classes,
     Graphics,Controls,Forms,Dialogs,StdCtrls,ExtCtrls,
     ComCtrls;

type TfrmFileHash = class(TForm)
       lvMD5: TListView;
       pnlButtons: TPanel;
       cmdAddFiles: TButton;
       cmdDelEntry: TButton;
       cmdCopy: TButton;
       cmdClose: TButton;
       dlg: TOpenDialog;
       mem: TMemo;
       procedure FormKeyPress(Sender: TObject; var Key: Char);
       procedure cmdAddFilesClick(Sender: TObject);
       procedure cmdDelEntryClick(Sender: TObject);
       procedure cmdCopyClick(Sender: TObject);
       procedure cmdCloseClick(Sender: TObject);
       procedure FormCreate(Sender: TObject);
     private
       procedure DropMsg(var msg : TWMDropFiles); message WM_DROPFILES;
       function MD5FileHash(sFile : string) : string;
     public
     end;

var frmFileHash : TfrmFileHash;

implementation

{$R *.dfm}

uses VPAExt,MD5,Hash,ShellAPI;

procedure TfrmFileHash.FormCreate(Sender: TObject);
begin
  DragAcceptFiles(Handle,true);
end;

procedure TfrmFileHash.DropMsg(var msg : TWMDropFiles);

var n,j,nFile : integer;
    Files : array[0..255] of char;
    FName : string;
    i : TListItem;
    sl : TFileStrings;

procedure Include(f : string);
begin
  if lvMD5.FindCaption(0,f,false,true,false) <> nil then exit;
  i := lvMD5.Items.Add;
  i.Caption := f;
  i.SubItems.Add(MD5FileHash(f));
end;

begin
  nFile := DragQueryFile(Msg.Drop,$FFFFFFFF,Files,0);
  lvMD5.Items.BeginUpdate;

  try
    for n := 0 to nFile - 1 do
    begin
      FName := copy(Files,0,DragQueryFile(Msg.Drop,n,Files,255));

      if DirectoryExists(FName) then
      begin
        sl := TFileStrings.Create(FName,'*.*',true,true);

        try
          for j := 0 to sl.Count - 1 do
            Include(sl[j]);
          finally
            sl.Free;
          end;
      end
      else Include(FName);
    end;
  finally
    Msg.Result := 0;
    DragFinish(msg.Drop);
    lvMD5.Items.EndUpdate;
  end;
end;

function TfrmFileHash.MD5FileHash(sFile : string) : string;

function CalcMD5Sum(sFile : string) : string;

var buffer : array[0..$8000 - 1] of char;
    err : word;
    md5 : TMD5Digest;

function MD5DigestToString(md5 : TMD5Digest) : string;

var i : integer;

begin
  Result := '';

  for i := 0 to 15 do
    Result := Result + IntToHex(md5[i],2);
end;

begin // CalcMD5Sum()
  try
    MD5File(sFile,md5,buffer,$8000,err);
  except
    err := 9;
  end;

  if err = 0 then
    Result := MD5DigestToString(md5)
  else
    Result := '';
end;

begin // MD5FileHash()
  Result := CalcMD5Sum(sFile);
end;

procedure TfrmFileHash.cmdAddFilesClick(Sender: TObject);

var n : integer;
    i : TListItem;

begin
  if not dlg.Execute then exit;

  for n := 0 to dlg.Files.Count - 1 do
  begin
    i := lvMD5.Items.Add;
    i.Caption := dlg.Files[n];
    i.SubItems.Add(MD5FileHash(dlg.Files[n]));
    Application.ProcessMessages;
  end;
end;

procedure TfrmFileHash.cmdCloseClick(Sender: TObject);
begin
  Close;
end;

procedure TfrmFileHash.cmdDelEntryClick(Sender: TObject);
begin
  lvMD5.Items.Clear;
end;

procedure TfrmFileHash.FormKeyPress(Sender: TObject; var Key: Char);
begin
  if Key = Esc then Close;
end;

procedure TfrmFileHash.cmdCopyClick(Sender: TObject);

var n : integer;

begin
  mem.Text := '';

  for n := 0 to lvMD5.Items.Count - 1 do
    mem.Lines.Add(lvMD5.Items[n].Caption + ',' +
     lvMD5.Items[n].SubItems[0]);

  mem.SelectAll;
  mem.CopyToClipboard;
end;

end.
