unit Main;

interface

uses Jobs,Windows,Messages,SysUtils,Variants,Classes,
     Graphics,Controls,Forms,Dialogs,ExtCtrls,Menus,
     ComCtrls,StdCtrls,Spin,ShellAPI;

const c_App = 'SolidCopy';
      c_Ver = 'v2.2';
      c_Copyright = 'open-source freeware';
      c_URL = 'http://code.google.com/p/solidcopy/';
      c_Spec = 0; {lv subitems; Caption = Spec.SrcRoot}
      c_Sub = 1;
      c_Trg = 2;
      c_TrgRoot = 3;
      c_Mode = 4;
      c_Size = 5;
      rvCancel = 0;
      rvOk = 1;
      CM_TRAYICON = CM_BASE + 100;
      c_NoErr = ' - no errors reported';

type TfrmMain = class(TForm)
       pag: TPageControl;
       tabFiles: TTabSheet;
       tabOptions: TTabSheet;
       mnuMain: TMainMenu;
       mnuFile: TMenuItem;
       mnuNew: TMenuItem;
       mnuOpen: TMenuItem;
       mnuSave: TMenuItem;
       mnuDefault: TMenuItem;
       mnuStart: TMenuItem;
       mnuDriveSpace: TMenuItem;
       mnuAbout: TMenuItem;
       mnuExit: TMenuItem;
       dlgOpen: TOpenDialog;
       dlgSave: TSaveDialog;
       tabStatus: TTabSheet;
       tabResults: TTabSheet;
       lv: TListView;
       pnlButtons: TPanel;
       cmdAddFolder: TButton;
       cmdAddFiles: TButton;
       cmdEditEntry: TButton;
       cmdDelEntry: TButton;
       cmdSkipList: TButton;
       cmdJobStart: TButton;
       popFiles: TPopupMenu;
       mnuAddFolder: TMenuItem;
       mnuAddFiles: TMenuItem;
       mnuEdit: TMenuItem;
       mnuRemove: TMenuItem;
       mnuSkipList: TMenuItem;
       nbyStart: TMenuItem;
       N1: TMenuItem;
       mnuButtonsMenu: TMenuItem;
       pnlRetryOpts: TPanel;
       lblRetryCount: TLabel;
       lblRetryInt: TLabel;
       chkRetry: TCheckBox;
       spnRetry: TSpinEdit;
       spnRetryInt: TSpinEdit;
       chkRetryForever: TCheckBox;
       chkLogs: TCheckBox;
       chkMD5: TCheckBox;
       chkNoCopy: TCheckBox;
       chkDelTrg: TCheckBox;
       chkDelEmpty: TCheckBox;
       pnlHCurrFolder: TPanel;
       pnlHFile: TPanel;
       lblFolder: TLabel;
       pnlFolder: TPanel;
       pnlHFilePrg: TPanel;
       pnlHAll: TPanel;
       pnlHDest: TPanel;
       lblFile: TLabel;
       pnlFile: TPanel;
       lblDest: TLabel;
       pnlDest: TPanel;
       red: TRichEdit;
       lblPrg: TLabel;
       prgFile: TProgressBar;
       lblOverall: TLabel;
       prgAll: TProgressBar;
       N2: TMenuItem;
       N3: TMenuItem;
       N4: TMenuItem;
       mnuTools: TMenuItem;
       mnuHelp: TMenuItem;
       mnuCurrentConfig: TMenuItem;
       mnuDocumentation: TMenuItem;
       mnuCCAddFolder: TMenuItem;
       mnuCCAddFiles: TMenuItem;
       mnuCCEditSelected: TMenuItem;
       mnuCCRemoveSelected: TMenuItem;
       N5: TMenuItem;
       mnuCCSkipList: TMenuItem;
       N6: TMenuItem;
       popTray: TPopupMenu;
       mnuShow: TMenuItem;
       mnuHide: TMenuItem;
       mnuTrayExit: TMenuItem;
       mnuMD5Hash: TMenuItem;
       dlgAddFiles: TOpenDialog;
       pnlCounts: TPanel;
       pnlMsg: TPanel;
       pnlHOk: TPanel;
       lblOk: TLabel;
       pnlOk: TPanel;
       pnlHSkipped: TPanel;
       lblSkip: TLabel;
       pnlSkip: TPanel;
       pnlHErrs: TPanel;
       lblErr: TLabel;
       pnlErr: TPanel;
       pnlHRecoveries: TPanel;
       lblRecover: TLabel;
       pnlRecover: TPanel;
       pnlStatus: TPanel;
       pnlHTotalFiles: TPanel;
       lblTotFiles: TLabel;
       pnlFileTotal: TPanel;
       pnlMargin: TPanel;
       pnlHTotalSize: TPanel;
       lblTotSize: TLabel;
       pnlGrand: TPanel;
       pnlHCopied: TPanel;
       lblBytesRem: TLabel;
       pnlBytesRemaining: TPanel;
       pnlHElapsed: TPanel;
       lblElapsed: TLabel;
       pnlElapsed: TPanel;
       pnlHRemaining: TPanel;
       lblRemain: TLabel;
       pnlRemain: TPanel;
       pnlHSpeed: TPanel;
       lblThruput: TLabel;
       pnlSpeed: TPanel;
       mnuZapLogs: TMenuItem;
       cmdResetOptions: TButton;
       cmdStart: TButton;
       cmdPause: TButton;
       cmdCancel: TButton;
       mnuEditAsText: TMenuItem;
       N7: TMenuItem;
       tmrAuto: TTimer;
       mnuMergeConfigs: TMenuItem;
       dlgMC: TOpenDialog;
       cmdMoveDown: TButton;
       cmdMoveUp: TButton;
       mnuMoveUp: TMenuItem;
       mnuMoveDown: TMenuItem;
       mnuCCMoveUp: TMenuItem;
       mnuCCMoveDown: TMenuItem;
       lvRes: TListView;
       splRes: TSplitter;
       cmdClone: TButton;
       mnuClone: TMenuItem;
       mnuPopClone: TMenuItem;
       redDox: TRichEdit;
       mnuPopNew: TMenuItem;
       mnuPopOpen: TMenuItem;
       mnuFilesNew: TMenuItem;
       mnuFilesOpen: TMenuItem;
       procedure FormActivate(Sender: TObject);
       procedure FormCreate(Sender: TObject);
       procedure FormDestroy(Sender: TObject);
       procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
       procedure cmdPauseClick(Sender: TObject);
       procedure cmdAddFolderClick(Sender: TObject);
       procedure cmdAddFilesClick(Sender: TObject);
       procedure cmdEditEntryClick(Sender: TObject);
       procedure cmdSkipListClick(Sender: TObject);
       procedure cmdStartClick(Sender: TObject);
       procedure mnuButtonsMenuClick(Sender: TObject);
       procedure cmdCancelClick(Sender: TObject);
       procedure mnuTrayExitClick(Sender: TObject);
       procedure mnuDefaultClick(Sender: TObject);
       procedure mnuNewClick(Sender: TObject);
       procedure mnuOpenClick(Sender: TObject);
       procedure mnuSaveClick(Sender: TObject);
       procedure cmdDelEntryClick(Sender: TObject);
       procedure mnuExitClick(Sender: TObject);
       procedure mnuDriveSpaceClick(Sender: TObject);
       procedure mnuDocumentationClick(Sender: TObject);
       procedure mnuAboutClick(Sender: TObject);
       procedure chkDelClick(Sender: TObject);
       procedure mnuMD5HashClick(Sender: TObject);
       procedure mnuShowClick(Sender: TObject);
       procedure mnuHideClick(Sender: TObject);
       procedure FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
       procedure mnuZapLogsClick(Sender: TObject);
       procedure cmdResetOptionsClick(Sender: TObject);
       procedure mnuEditAsTextClick(Sender: TObject);
       procedure tmrAutoTimer(Sender: TObject);
       procedure mnuMergeConfigsClick(Sender: TObject);
       procedure cmdSkipListMouseEnter(Sender: TObject);
       procedure cmdSkipListMouseLeave(Sender: TObject);
       procedure cmdMoveUpClick(Sender: TObject);
       procedure cmdMoveDownClick(Sender: TObject);
       procedure lvClick(Sender: TObject);
       procedure lvResSelectItem(Sender: TObject; Item: TListItem; Selected: Boolean);
       procedure lvResDblClick(Sender: TObject);
       procedure cmdCloneClick(Sender: TObject);
     private
       bInit,bBusy : boolean;
       DropTrg : integer;
       TrayIconData : TNotifyIconData;
       slPendingSkips : TStringList;
       procedure TrayMessage(var Msg: TMessage); message CM_TRAYICON;
       procedure DropMsg(var msg : TWMDropFiles); message WM_DROPFILES;
       procedure TransferPendingSkips;
       procedure EnableOpts(b : boolean);
       procedure AdjustOptions;
       procedure ExchangeItems(const n2 : integer);
       procedure LoadLogs;
       procedure LoadOptions(sFile : string);
       procedure SaveOptions(sFile : string);
       procedure SetTrayHint(sHint : string);
       procedure ResetFields;
       procedure DoWork;
     public
       cfg : string;
       procedure QuickLog(Config,Msg : string);
       function AddLog(sFile : string) : TListItem;
       procedure UpdateStatus;
       procedure UpdateCounts;
       procedure Yield;
     end;

var frmMain : TfrmMain;
    bAuto : boolean;
    Work : TJob;
    UDir : string;

implementation

{$R *.dfm}
{$R SolidCopy_Resources.res}

uses VPAExt,EditProps,Preview,About,DriveSpace,SkipList,
     FileHash,EditAsText,StrUtils;

procedure TfrmMain.FormCreate(Sender: TObject);
begin
  bAuto := ParamCount > 0;
  bInit := false;
  bBusy := false;
  cfg := '';
  slPendingSkips := TStringList.Create;
  red.Font.Name := 'Courier New';
  FileMode := fmOpenRead;
  DragAcceptFiles(Handle,true);
  UDir := GetDataPath + c_App;
  if not DirectoryExists(UDir) then MkDir(UDir);
  UDir := UDir + '\';
  if not DirectoryExists(UDir + 'Logs') then MkDir(UDir + 'Logs');

  with TrayIconData do
  begin
    cbSize := SizeOf(TrayIconData);
    Wnd := Handle;
    uID := 0;
    uFlags := NIF_MESSAGE + NIF_ICON + NIF_TIP;
    uCallbackMessage := CM_TRAYICON;
    hIcon := Application.Icon.Handle;
    StrPCopy(szTip,c_App);
  end;

  Shell_NotifyIcon(NIM_ADD,@TrayIconData);
  pag.ActivePage := tabFiles;
end;

procedure TfrmMain.FormActivate(Sender: TObject);

var rs : TResourceStream;

begin
  if bInit then exit;
  bInit := true;
  if bAuto then exit;
  LoadOptions(UDir + 'Default.scc');
  LoadLogs;
  AdjustOptions;
  Caption := c_App;
  rs := TResourceStream.Create(hInstance,PChar('Dox'),RT_RCDATA);

  try
    rs.Position := 0;
    redDox.Lines.LoadFromStream(rs);
    redDox.Align := alClient;
  finally
    rs.Free;
  end;
end;

procedure TfrmMain.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  if bBusy then
  begin
    if Confirm(c_App,'Cancel?') then
    begin
      bBusy := false;
      Work.bCancel := true;
      CanClose := false;
    end;
  end;

  if not bAuto then
  begin
    SaveApp(Application);
    AddAppVar(c_App,'ButtonsMenu',YN(mnuButtonsMenu.Checked));
    AddAppVar(c_App,'lvResHeight',IntToStr(lvRes.Height));
  end;
end;

procedure TfrmMain.FormDestroy(Sender: TObject);
begin
  Shell_NotifyIcon(NIM_DELETE,@TrayIconData);
  slPendingSkips.Free;
  try ChDir('C:\'); except; end;
end;

procedure TfrmMain.FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
  if (ActiveControl = lv) and (Key = VK_RETURN) then
    cmdEditEntryClick(Self);
end;

procedure TfrmMain.tmrAutoTimer(Sender: TObject);

var sFile,sConfig : string;

begin
  tmrAuto.Enabled := false;
  LoadApp(Application);
  mnuButtonsMenu.Checked := YN(GetAppVar(c_App,'ButtonsMenu'));
  pnlButtons.Visible := mnuButtonsMenu.Checked;
  sConfig := GetAppVar(c_App,'lvResHeight');
  if sConfig <> '' then lvRes.Height := StrToInt2(sConfig);
  if not bAuto then exit;
  sConfig := ParamStr(1);

  if FileExists(sConfig) then
    sFile := sConfig
  else if FileExists(sConfig + '.scc') then
    sFile := sConfig + '.scc'
  else
    sFile := UDir + sConfig + '.scc';

  if FileExists(sFile) then
  begin
    LoadOptions(sFile);
    cmdStartClick(Self);
  end
  else QuickLog(sFile,'Config not found.');

  bBusy := false;
  Close;
end;

procedure TfrmMain.EnableOpts(b : boolean);
begin
  mnuFile.Enabled := b;
  tabOptions.Enabled := b;
  cmdPause.Visible := (not b);
  cmdStart.Visible := b;
  cmdCancel.Visible := (not b);
end;

function TfrmMain.AddLog(sFile : string) : TListItem;

var bErr : boolean;
    LogName,
    sConfig : string;

begin
  LogName :=ExtractFilename(StripExt(sFile));
  Result := lvRes.Items.Add;

  try
    with Result do
    begin
      Caption := NiceID(copy(LogName,1,17));
      bErr := pos(c_NoErr,LogName) = 0;
      sConfig := StrAfter(LogName,'_');
      sConfig := StrUntil(sConfig,' - ');
      SubItems.Add(sConfig);
      SubItems.Add(YN(bErr));
      Data := TObjStr.Create(sFile);
    end;
  except
    Result := nil;
  end;
end;

procedure TfrmMain.LoadLogs;

var sl : TFileStrings;
    n : integer;

begin
  sl := TFileStrings.Create(UDir + 'Logs\','*.txt',true,false);
  lvRes.Items.BeginUpdate;

  try
    for n := 0 to sl.Count - 1 do
      AddLog(sl[n]);
  finally
    sl.Free;
    lvRes.Items.EndUpdate;
  end;
end;

procedure TfrmMain.DropMsg(var msg : TWMDropFiles);

var n,nFile : integer;
    Files : array[0..255] of char;
    FName,Trg : string;
    i : TListItem;

begin
  nFile := DragQueryFile(Msg.Drop,$FFFFFFFF,Files,0);

  if DropTrg <> 2 then
  begin
    Trg := GetDirectory(c_App + ' TARGET Folder');;
    if Trg = '' then exit;
  end
  else frmSkipList.Show;

  for n := 0 to nFile - 1 do
  begin
    FName := copy(Files,0,DragQueryFile(Msg.Drop,n,Files,255));

    if DropTrg <> 2 then
    begin
      i := lv.Items.Add;

      if DirectoryExists(FName) then
      begin
        i.Caption := FName;
        i.SubItems.Add('*.*');
        i.SubItems.Add('Y');
      end
      else
      begin
        i.Caption := ExtractFilePath(FName);
        i.SubItems.Add(ExtractFilename(FName));
        i.SubItems.Add('N');
      end;

      i.SubItems.Add(Trg);
      i.SubItems.Add(LastDir(i.Caption));
      i.SubItems.Add('pending');
      lv.Selected := i;
      i.MakeVisible(false);
    end
    else with frmSkipList do
    begin
      if lvSkip.FindCaption(0,FName,false,true,false) = nil then
      begin
        i := lvSkip.Items.Add;
        i.Caption := FName;
      end;
    end;
  end;

  Msg.Result := 0;
  DragFinish(msg.Drop);
end;

procedure TfrmMain.cmdSkipListMouseEnter(Sender: TObject);
begin
  DropTrg := 2;
end;

procedure TfrmMain.cmdSkipListMouseLeave(Sender: TObject);
begin
  DropTrg := 1;
end;

procedure TfrmMain.AdjustOptions;
begin
  if chkNoCopy.Checked then
  begin
    chkMD5.Checked := false;
    chkMD5.Enabled := false;
    chkDelTrg.Checked := false;
    chkDelTrg.Enabled := false;
    chkDelEmpty.Checked := false;
  end
  else
  begin
    chkMD5.Enabled := true;
    chkDelTrg.Enabled := true;
  end;

  spnRetry.Enabled := chkRetry.Checked;
  spnRetryInt.Enabled := chkRetry.Checked;
  chkRetryForever.Enabled := chkRetry.Checked;
end;

procedure TfrmMain.SaveOptions(sFile : string);

var n : integer;
    txt : textfile;
    i : TListItem;

begin
  AssignFile(txt,sFile);
  Rewrite(txt);
  WriteLn(txt,'Retry=' + YN(chkRetry.Checked));
  WriteLn(txt,'RetryCount=' + IntToStr(spnRetry.Value));
  WriteLn(txt,'RetryInt=' + IntToStr(spnRetryInt.Value));
  WriteLn(txt,'RetryForever=' + YN(chkRetry.Checked));
  WriteLn(txt,'MD5=' + YN(chkMD5.Checked));
  WriteLn(txt,'NoCopy=' + YN(chkNoCopy.Checked));
  WriteLn(txt,'Mirror=' + YN(chkDelTrg.Checked));
  WriteLn(txt,'DelEmpty=' + YN(chkDelEmpty.Checked));

  for n := 0 to frmSkipList.lvSkip.Items.Count - 1 do
    WriteLn(txt,'Skip=' + frmSkipList.lvSkip.Items[n].Caption);

  for n := 0 to lv.Items.Count - 1 do
  begin
    i := lv.Items[n];
    WriteLn(txt,'Src=' + i.Caption);
    WriteLn(txt,'Spec=' + i.SubItems[c_Spec]);
    WriteLn(txt,'Sub=' + i.SubItems[c_Sub]);
    WriteLn(txt,'Trg=' + i.SubItems[c_Trg]);
    WriteLn(txt,'TrgRoot=' + i.SubItems[c_TrgRoot]);
    WriteLn(txt,'Mode=' + i.SubItems[c_Mode]);
  end;

  CloseFile(txt);
  cfg := StripExt(ExtractFilename(sFile));
  Caption := c_App + ' - ' + cfg;
end;

{$I+}
procedure TfrmMain.LoadOptions(sFile : string);

var sl : TStringList;
    n : integer;
    i : TListItem;

begin
  if not FileExists(sFile) then exit;
  ResetFields;
  sl := TStringList.Create;

  try
    i := nil;
    slPendingSkips.Clear;
    sl.LoadFromFile(sFile);

    for n := 0 to sl.Count - 1 do
    begin
      if sl.Names[n] = 'Src' then
      begin
        i := lv.Items.Add;
        i.Caption := sl.ValueFromIndex[n];
        i.SubItems.Add('');
        i.SubItems.Add('');
        i.SubItems.Add('');
        i.SubItems.Add('');
        i.SubItems.Add('');
        i.SubItems.Add('pending');
      end;

      if sl.Names[n] = 'Spec' then
        i.SubItems[c_Spec] := sl.ValueFromIndex[n];

      if sl.Names[n] = 'Sub' then
        i.SubItems[c_Sub] := sl.ValueFromIndex[n];

      if sl.Names[n] = 'Trg' then
        i.SubItems[c_Trg] := sl.ValueFromIndex[n];

      if sl.Names[n] = 'TrgRoot' then
        i.SubItems[c_TrgRoot] := sl.ValueFromIndex[n];

      if sl.Names[n] = 'Mode' then
      begin
        i.SubItems[c_Mode] := sl.ValueFromIndex[n];
        frmEditProps.cmbMode.ItemIndex := frmEditProps.cmbMode.Items.IndexOf(i.SubItems[c_Mode]);
      end;

      if sl.Names[n] = 'Skip' then
        slPendingSkips.Add(sl.ValueFromIndex[n]);

      if sl.Names[n] = 'Retry' then
        chkRetry.Checked := sl.ValueFromIndex[n] = 'Y';

      if sl.Names[n] = 'RetryCount' then
        spnRetry.Value := StrToInt2(sl.ValueFromIndex[n]);

      if sl.Names[n] = 'RetryInt' then
        spnRetryInt.Value := StrToInt2(sl.ValueFromIndex[n]);

      if sl.Names[n] = 'RetryForever' then
        chkRetryForever.Checked := sl.ValueFromIndex[n] = 'Y';

      if sl.Names[n] = 'MD5' then
        chkMD5.Checked := sl.ValueFromIndex[n] = 'Y';

      if sl.Names[n] = 'NoCopy' then
        chkNoCopy.Checked := sl.ValueFromIndex[n] = 'Y';

      if sl.Names[n] = 'Mirror' then
        chkDelTrg.Checked := sl.ValueFromIndex[n] = 'Y';

      if sl.Names[n] = 'DelEmpty' then
        chkDelEmpty.Checked := sl.ValueFromIndex[n] = 'Y';
    end;

    cfg := StripExt(ExtractFilename(sFile));
    Caption := c_App + ' - ' + cfg;
  except on e : exception do
    if bAuto then
      QuickLog(sFile,e.Message)
    else
      ShowMessage(sFile + #13#13 + e.Message);
  end;

  sl.Free;
end;

procedure TfrmMain.TransferPendingSkips;

var i : TListItem;
    n : integer;

begin
  for n := 0 to slPendingSkips.Count - 1 do
  begin
    if frmSkipList.lvSkip.FindCaption(0,
     slPendingSkips[n],false,true,false) = nil then
    begin
      i := frmSkipList.lvSkip.Items.Add;
      i.Caption := slPendingSkips[n];
    end;
  end;

  slPendingSkips.Clear;
end;

procedure TfrmMain.lvClick(Sender: TObject);
begin
  cmdMoveUp.Enabled := lv.ItemIndex > 0;
  mnuMoveUp.Enabled := cmdMoveUp.Enabled;
  mnuCCMoveUp.Enabled := cmdMoveUp.Enabled;
  cmdMoveDown.Enabled := lv.ItemIndex < lv.Items.Count - 1;
  mnuMoveDown.Enabled := cmdMoveDown.Enabled;
  mnuCCMoveDown.Enabled := cmdMoveDown.Enabled;
end;

procedure TfrmMain.lvResDblClick(Sender: TObject);
begin
  if lvRes.Selected = nil then exit;
  RunAssoc(TObjStr(lvRes.Selected.Data).s);
end;

procedure TfrmMain.lvResSelectItem(Sender: TObject; Item: TListItem; Selected: Boolean);
begin
  if (not Selected) or (Item = nil) then exit;
  red.Text := ''; {fixes caret}

  try
    red.Lines.LoadFromFile(TObjStr(Item.Data).s);
  except on e : exception do
    red.Text := e.Message;
  end;
end;

procedure TfrmMain.mnuButtonsMenuClick(Sender: TObject);
begin
  mnuButtonsMenu.Checked := (not mnuButtonsMenu.Checked);
  pnlButtons.Visible := mnuButtonsMenu.Checked;
end;

procedure TfrmMain.mnuShowClick(Sender: TObject);
begin
  Show;
end;

procedure TfrmMain.mnuTrayExitClick(Sender: TObject);
begin
  Close;
end;

procedure TfrmMain.mnuZapLogsClick(Sender: TObject);

var sl : TFileStrings;

begin
  sl := TFileStrings.Create(UDir + 'Logs','*.txt',true,false);

  try
    if sl.Count > 0 then
    begin
      if Confirm(c_App,'Permanently delete ' +
       CommaStr(IntToStr(sl.Count)) + ' log files?') then
      begin
        try
          DelSpec(UDir + 'Logs\*.txt');
          pag.ActivePage := tabResults;
          lvRes.Items.Clear;
          red.Text := 'Logs zapped.';
        except on e : exception do
          ShowMessage(e.Message);
        end;
      end;
    end
    else ShowMessage('No logs found.');
  finally
    sl.Free;
  end;
end;

procedure TfrmMain.Yield;
begin
  Application.ProcessMessages;
end;

procedure TfrmMain.cmdPauseClick(Sender: TObject);
begin
  if cmdPause.Caption = '&Pause' then
    cmdPause.Caption := '&Resume'
  else
    cmdPause.Caption := '&Pause';

  while cmdPause.Caption = '&Resume' do
  begin
    Sleep(100);
    Application.ProcessMessages;
  end;
end;

procedure TfrmMain.cmdAddFolderClick(Sender: TObject);

var i : TListItem;
    Src,Trg : string;

begin
  Src := GetDirectory(c_App + ' SOURCE Folder');
  if Src = '' then exit;
  Trg := GetDirectory(c_App + ' TARGET Folder');;
  if Trg = '' then exit;

  if Src = Trg then
  begin
    ShowMessage('Source cannot equal target.');
    exit;
  end;

  i := lv.Items.Add;
  i.Caption := FinalBS(Src);
  i.SubItems.Add('*.*');
  i.SubItems.Add('Y');
  i.SubItems.Add(FinalBS(Trg));
  i.SubItems.Add(LastDir(Src));
  i.SubItems.Add('if target is older');
  i.SubItems.Add('pending');
end;

procedure TfrmMain.cmdAddFilesClick(Sender: TObject);

var i : TListItem;
    n : integer;
    Trg : string;

begin
  if not dlgAddFiles.Execute then exit;
  Trg := GetDirectory(c_App + ' TARGET Folder');

  if Trg = '' then
    exit
  else
    Trg := FinalBS(Trg);

  if Trg = ExtractFilePath(dlgAddFiles.Files[0]) then
  begin
    ShowMessage('Source cannot equal target.');
    exit;
  end;

  for n := 0 to dlgAddFiles.Files.Count - 1 do
  begin
    i := lv.Items.Add;
    i.Caption := ExtractFilePath(dlgAddFiles.Files[n]);
    i.SubItems.Add(ExtractFileName(dlgAddFiles.Files[n]));
    i.SubItems.Add('N');
    i.SubItems.Add(Trg);
    i.SubItems.Add(LastDir(i.Caption));
    i.SubItems.Add('if target is older');
    i.SubItems.Add('pending');
  end;
end;

procedure TfrmMain.cmdCancelClick(Sender: TObject);
begin
  if bBusy then
    Work.bCancel := Confirm(c_App,'Cancel?');

  if (Work.bCancel) and (cmdPause.Visible) then
    cmdPause.Caption := '&Pause';
end;

procedure TfrmMain.cmdCloneClick(Sender: TObject);

var i : TListItem;

begin
  if lv.Selected = nil then exit;
  i := lv.Items.Add;
  i.Assign(lv.Selected);
end;

procedure TfrmMain.QuickLog(Config,Msg : string);
begin
  AddFileText(UDir + 'Logs\_Errors.txt',
   TimeStr(Now) + ' - ' + Config + ' - ' + Msg);
end;

procedure TfrmMain.TrayMessage(var Msg: TMessage);

var p : TPoint;

begin
  case Msg.lParam of
    WM_LBUTTONDOWN : Show;
    WM_RBUTTONDOWN :
    begin
      SetForegroundWindow(Handle);
      GetCursorPos(p);
      popTray.Popup(p.x,p.y);
      PostMessage(Handle,WM_NULL,0,0);
    end;
  end;
end;

procedure TfrmMain.SetTrayHint(sHint : string);
begin
  Application.Hint := c_App + ' - ' + sHint;
  StrPCopy(TrayIconData.szTip,Application.Hint);
  Shell_NotifyIcon(NIM_MODIFY,@TrayIconData);
end;

procedure TfrmMain.UpdateCounts;
begin
  pnlOk.Caption := CommaStr(IntToStr(Work.slOk.Count));
  pnlSkip.Caption := CommaStr(IntToStr(Work.slSkip.Count));
  pnlErr.Caption := CommaStr(IntToStr(Work.slErr.Count));
  pnlRecover.Caption := CommaStr(IntToStr(Work.slRecover.Count));
  Yield;
end;

procedure TfrmMain.UpdateStatus;

var nPercent : byte;
    nLeft,nSecs,nRemSecs,nElapsedSecs : longword;
    nMegPerSec : integer;

begin
  Yield;
  if not bBusy then exit;

  nSecs := (Round(Frac(Now) * SecsPerDay)) -
   (Round(Frac(Work.dtUpWait) * SecsPerDay));

  if nSecs < 1 then exit;
  Work.dtUpWait := Now;
  nMegPerSec := 0;
  pnlBytesRemaining.Caption := FileSizeText(Work.nCopyBytes - Work.nOkBytes);

  nLeft := Work.nFileTotal - Work.slOk.Count -
   Work.slErr.Count - Work.slSkip.Count;

  pnlFileTotal.Hint := CommaStr(IntToStr(nLeft)) + ' files pending';
  pnlBytesRemaining.Hint := pnlFileTotal.Hint;

  nElapsedSecs := Round(
   (Now - Work.dtStart) * SecsPerDay);

  pnlElapsed.Caption :=
   ZeroPad(IntToStr(nElapsedSecs div 3600),2) + ':' +
   ZeroPad(IntToStr((nElapsedSecs mod 3600) div 60),2) + ':' +
   ZeroPad(IntToStr((nElapsedSecs mod 3600) mod 60),2);

  if nElapsedSecs > 0 then
  begin
    nMegPerSec := Round(((Work.nOkBytes / 1024) / nElapsedSecs));

    if nMegPerSec > Work.nBestSpeed then
      Work.nBestSpeed := nMegPerSec;
  end;

  pnlSpeed.Caption := CommaStr(IntToStr(nMegPerSec)) + ' MB/sec';

  if (Work.nCopyBytes = 0) or (nMegPerSec = 0) then
    exit;

  nPercent := Round((Work.nOkBytes / Work.nCopyBytes) * 100);

  prgAll.Hint := IntToStr(nPercent) + '% - ' +
   FileSizeText(Work.nCopyBytes - Work.nOkBytes) +
   ' in ' + CommaStr(IntToStr(nLeft)) + ' files remain';

  SetTrayHint(prgAll.Hint);
  prgAll.Position := nPercent;
  nRemSecs := Round(((Work.nCopyBytes - Work.nOkBytes) / 1024) / nMegPerSec);

  pnlRemain.Caption :=
   ZeroPad(IntToStr(nRemSecs div 3600),2) + ':' +
   ZeroPad(IntToStr((nRemSecs mod 3600) div 60),2) + ':' +
   ZeroPad(IntToStr((nRemSecs mod 3600) mod 60),2);
end;

procedure TfrmMain.ResetFields;
begin
  pag.ActivePage := tabFiles;
  cmdResetOptionsClick(Self);
  lv.Items.Clear;
  Caption := c_App;

  if frmSkipList <> nil then
    frmSkipList.lvSkip.Items.Clear;
end;

procedure TfrmMain.mnuNewClick(Sender: TObject);
begin
  if bBusy then exit;
  ResetFields;
  slPendingSkips.Clear;
  frmSkipList.lvSkip.Items.Clear;
end;

procedure TfrmMain.mnuOpenClick(Sender: TObject);
begin
  if bBusy then exit;
  dlgOpen.InitialDir := UDir;

  if dlgOpen.Execute then
    LoadOptions(dlgOpen.FileName);
end;

procedure TfrmMain.mnuSaveClick(Sender: TObject);
begin
  if lv.Items.Count = 0 then
  begin
    ShowMessage('Add some files or folders first.');
    exit;
  end;

  dlgSave.InitialDir := UDir;

  if dlgSave.Execute then
    SaveOptions(dlgSave.FileName);
end;

procedure TfrmMain.mnuDefaultClick(Sender: TObject);
begin
  SaveOptions(UDir + 'Default.scc');
end;

procedure TfrmMain.mnuAboutClick(Sender: TObject);
begin
  frmAbout.Show;
end;

procedure TfrmMain.mnuDriveSpaceClick(Sender: TObject);
begin
  frmDriveSpace.Show;
end;

procedure TfrmMain.cmdDelEntryClick(Sender: TObject);
begin
  lv.DeleteSelected;
end;

procedure TfrmMain.cmdEditEntryClick(Sender: TObject);
begin
  if lv.Selected = nil then exit;

  with frmEditProps do
  begin
    edtSrc.Text := lv.Selected.Caption;
    edtSpec.Text := lv.Selected.SubItems[c_Spec];
    chkSub.Checked := YN(lv.Selected.SubItems[c_Sub]);
    edtTrg.Text := lv.Selected.SubItems[c_Trg];
    edtTrgRoot.Text := lv.Selected.SubItems[c_TrgRoot];
    cmbMode.ItemIndex := cmbMode.Items.IndexOf(lv.Selected.SubItems[c_Mode]);
    ShowModal;
    if RetVal = rvCancel then exit;

    if edtSrc.Text = edtTrg.Text then
    begin
      ShowMessage('Source cannot equal target.');
      exit;
    end;

    lv.Selected.Caption := edtSrc.Text;
    lv.Selected.SubItems[c_Spec] := edtSpec.Text;
    lv.Selected.SubItems[c_Sub] := YN(chkSub.Checked);
    lv.Selected.SubItems[c_Trg] := edtTrg.Text;
    lv.Selected.SubItems[c_TrgRoot] := edtTrgRoot.Text;
    lv.Selected.SubItems[c_Mode] := cmbMode.Text;
  end;
end;

procedure TfrmMain.cmdSkipListClick(Sender: TObject);
begin
  TransferPendingSkips;
  frmSkipList.Show;
end;

procedure TfrmMain.chkDelClick(Sender: TObject);
begin
  AdjustOptions;
end;

procedure TfrmMain.mnuExitClick(Sender: TObject);
begin
  Close;
end;

procedure TfrmMain.mnuHideClick(Sender: TObject);
begin
  Hide;
end;

procedure TfrmMain.cmdStartClick(Sender: TObject);
begin
  DoWork;
end;

procedure TfrmMain.DoWork;

var n : integer;
    sBad : string;

function BadFile : boolean;
begin
  Result := ((not FileSpec(lv.Items[n].SubItems[c_Spec])
   and (not FileExists(lv.Items[n].Caption +
   lv.Items[n].SubItems[c_Spec]))));
end;

function BadDir : boolean;
begin
  Result := (not DirectoryExists(lv.Items[n].Caption));
end;

begin
  if bBusy then exit;
  TransferPendingSkips;

  if not bAuto then
  begin
    if lv.Items.Count = 0 then
    begin
      pag.ActivePage := tabFiles;
      lv.SetFocus;
      ShowMessage('No config loaded, no folders/files added yet.');
      exit;
    end;

    for n := 0 to lv.Items.Count - 1 do
    begin
      sBad := '';

      if (BadDir) or (BadFile) then
        sBad := trim(lv.Items[n].Caption +
         lv.Items[n].SubItems[c_Spec]) + ' - ' +
         'Invalid Source - continue?';

      if (sBad = '') and (not DirectoryExists(lv.Items[n].SubItems[c_Trg])) then
        sBad := trim(lv.Items[n].SubItems[c_Trg]) + ' - ' +
         'Invalid Target - continue?';

      if (sBad <> '') and (not Confirm(c_App,sBad)) then
      begin
        pag.ActivePage := tabFiles;
        lv.Selected := lv.Items[n];
        lv.SetFocus;
        exit;
      end;
    end;
  end;

  bBusy := true;
  EnableOpts(false);
  SetTrayHint('scanning');
  red.Lines.Clear;
  pnlFile.Caption := 'scanning';
  pnlFile.Update;
  pnlOk.Caption := '0';
  pnlSkip.Caption := '0';
  pnlErr.Caption := '0';
  pnlRecover.Caption := '0';
  pnlGrand.Caption := '';
  pnlFileTotal.Caption := '';
  pnlRemain.Caption := '';
  pnlElapsed.Caption := '';
  pnlSpeed.Caption := '';
  pnlBytesRemaining.Caption := '';
  prgAll.Hint := '';
  pag.ActivePage := tabStatus;
  Work := TJob.Create;

  try
    if not Work.bCancel then
      Work.Start;
  except on e : exception do
    Work.slOther.Add('DoWork() - ' + e.Message);
  end;

  Work.Free;
  bBusy := false;
  pnlFile.Caption := '';
  pnlFolder.Caption := '';
  pnlDest.Caption := '';
  pnlBytesRemaining.Caption := '0';
  prgFile.Position := 0;
  prgAll.Position := 0;
  SetTrayHint(c_App);
  EnableOpts(not bAuto);
end;

procedure TfrmMain.mnuDocumentationClick(Sender: TObject);
begin
  pag.ActivePageIndex := 0;
  redDox.Visible := (not redDox.Visible);
end;

procedure TfrmMain.mnuMD5HashClick(Sender: TObject);
begin
  frmFileHash.Show;
end;

procedure TfrmMain.cmdResetOptionsClick(Sender: TObject);
begin
  cfg := '';
  Caption := c_App;
  chkRetry.Checked := false;
  chkMD5.Checked := false;
  chkNoCopy.Checked := false;
  chkDelTrg.Checked := false;
  chkDelEmpty.Checked := false;
  AdjustOptions;
end;

procedure TfrmMain.mnuEditAsTextClick(Sender: TObject);
begin
  if cfg = '' then
    SaveOptions(UDir + 'Default.scc')
  else
    SaveOptions(UDir + cfg + '.scc');

  with frmEditAsText do
  begin
    Caption := 'Edit As Text - ' + cfg;
    red.Lines.LoadFromFile(UDir + cfg + '.scc');
    if ShowModal <> mrOk then exit;
    red.Lines.SaveToFile(UDir + cfg + '.scc');
    LoadOptions(UDir + cfg + '.scc');
  end;
end;

procedure TfrmMain.mnuMergeConfigsClick(Sender: TObject);

var n : integer;
    slCurr : TStringList;
    sConfig : string;

begin
  dlgMC.InitialDir := UDir;
  if not dlgMC.Execute then exit;
  if dlgMC.Files.Count = 0 then exit;
  slCurr := TStringList.Create;
  sConfig := SerFile(UDir + 'Merged.scc');

  try
    for n := 0 to dlgMC.Files.Count - 1 do
    begin
      slCurr.LoadFromFile(dlgMC.Files[n]);
      AddFileText(sConfig,slCurr.Text);
    end;

    pag.ActivePage := tabFiles;
    LoadOptions(sConfig);
    SaveOptions(sConfig); {removes dupe options}

    if dlgMC.Files.Count > 1 then
    begin
      ShowMessage('Merged ' + IntToStr(dlgMC.Files.Count) +
       ' files; verify current options.');

      pag.ActivePage := tabOptions;
    end
    else ShowMessage('Cloned ' + dlgMC.Files[0]);
  finally
    slCurr.Free;
  end;
end;

procedure TfrmMain.cmdMoveUpClick(Sender: TObject);
begin
  ExchangeItems(lv.ItemIndex - 1);
end;

procedure TfrmMain.cmdMoveDownClick(Sender: TObject);
begin
  ExchangeItems(lv.ItemIndex + 1);
end;

procedure TfrmMain.ExchangeItems(const n2 : integer);

var i : TListItem;
    n : integer;

begin
  if lv.ItemIndex = -1 then exit;
  pag.ActivePage := tabFiles;
  n := lv.ItemIndex;
  lv.Items.BeginUpdate;
  i := TListItem.Create(lv.Items);

  try
    i.Assign(lv.Items[n]);
    lv.Items[n].Assign(lv.Items[n2]);
    lv.Items[n2].Assign(i);
    lv.ClearSelection;
    lv.Selected := lv.Items[n2];
    lv.SetFocus;
    lvClick(Self);
  finally
    i.Free;
    lv.Items.EndUpdate;
  end;
end;

end.
