unit Preview;

interface

uses Windows,Messages,SysUtils,Variants,Classes,Graphics,
     Controls,Forms,Dialogs,StdCtrls,ComCtrls,ExtCtrls;

const ptCopy   = 1;
      ptDelete = 2;

type TfrmPreview = class(TForm)
       pnlTop: TPanel;
       lvP: TListView;
       pnlSB: TPanel;
       prg: TProgressBar;
       lblMsg: TLabel;
       dlgSave: TSaveDialog;
       cmdSel: TButton;
       cmdDes: TButton;
       cmdSelAll: TButton;
       cmdDesAll: TButton;
       cmdSaveList: TButton;
       cmdProceed: TButton;
       cmdCancel: TButton;
       procedure FormActivate(Sender: TObject);
       procedure cmdProceedClick(Sender: TObject);
       procedure cmdCancelClick(Sender: TObject);
       procedure FormClose(Sender: TObject; var Action: TCloseAction);
       procedure FormCreate(Sender: TObject);
       procedure cmdSelAllClick(Sender: TObject);
       procedure cmdDesAllClick(Sender: TObject);
       procedure cmdSelClick(Sender: TObject);
       procedure lvPSelectItem(Sender: TObject; Item: TListItem; Selected: Boolean);
       procedure cmdDesClick(Sender: TObject);
       procedure cmdSaveListClick(Sender: TObject);
       procedure FormKeyPress(Sender: TObject; var Key: Char);
     private
       bInit,bBusy,bCancel : boolean;
       procedure CollectChanges;
       procedure ApplyChanges;
     public
     end;

var frmPreview : TfrmPreview;

implementation

{$R *.dfm}

uses VPAExt,Main;

procedure TfrmPreview.FormCreate(Sender: TObject);
begin
  bInit := false;
  bBusy := false;
  bCancel := false;
end;

procedure TfrmPreview.FormActivate(Sender: TObject);
begin
  if bInit then exit;
  bInit := true;
  lvP.Items.Clear;
  WindowState := wsMaximized;
  cmdSelAll.Visible := false;
  cmdDesAll.Visible := false;
  cmdProceed.Visible := false;

  CollectChanges;

  cmdSelAll.Visible := true;
  cmdDesAll.Visible := true;
  cmdProceed.Visible := true;
end;

procedure TfrmPreview.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  bInit := false;
  bBusy := false;
  bCancel := false;
end;

procedure TfrmPreview.FormKeyPress(Sender: TObject; var Key: Char);
begin
  if Key = #27 then Close;
end;

procedure TfrmPreview.cmdCancelClick(Sender: TObject);

var n : integer;

begin
  if bBusy then
  begin
    if MessageDlg('Cancel?',mtConfirmation,
     [mbYes,mbNo],0) = IDYES then bCancel := true;

    exit;
  end;

  for n := 0 to lvP.Items.Count - 1 do
    Work.slSkip.Add(lvP.Items[n].Caption);

  Close;
end;

procedure TfrmPreview.cmdProceedClick(Sender: TObject);
begin
  ApplyChanges;
end;

procedure TfrmPreview.CollectChanges;

var   n  : integer;
      i  : TListItem;
      sl : TStringList;

begin
  lblMsg.Caption := 'Building list...';
  sl := Work.slPrompt;
  lvP.Columns[0].Caption := 'From';
  lvP.Columns[0].Width := Screen.Width div 2;
  Caption := c_App + ' - Confirm Overwrites';
  prg.Max := sl.Count;

  for n := 0 to sl.Count - 1 do
  begin
    if bCancel then break;
    prg.Position := n + 1;
    Application.ProcessMessages;
    i := lvP.Items.Add;
    i.Caption := copy(sl[n],1,pos('+++',sl[n]) - 1);
    i.SubItems.Add(copy(sl[n],pos('+++',sl[n]) + 3,254));
  end;

  lblMsg.Caption := 'Finished with ' +
   CommaStr(IntToStr(lvP.Items.Count)) +
   ' items for review.';

  prg.Position := 0;
end;

procedure TfrmPreview.lvPSelectItem(Sender: TObject; Item: TListItem; Selected: Boolean);
begin
  lvP.Hint := ExtractFilename(Item.Caption);
end;

procedure TfrmPreview.cmdSelClick(Sender: TObject);

var n : integer;

begin
  for n := 0 to lvP.Items.Count - 1 do
    if lvP.Items[n].Selected then
      lvP.Items[n].Checked := true;

  lvP.SetFocus;
end;

procedure TfrmPreview.cmdDesClick(Sender: TObject);

var n : integer;

begin
  for n := 0 to lvP.Items.Count - 1 do
    if lvP.Items[n].Selected then
      lvP.Items[n].Checked := false;

  lvP.SetFocus;
end;

procedure TfrmPreview.cmdSelAllClick(Sender: TObject);

var n : integer;

begin
  for n := 0 to lvP.Items.Count - 1 do
    lvP.Items[n].Checked := true;

  lvP.SetFocus;
end;

procedure TfrmPreview.cmdDesAllClick(Sender: TObject);

var n : integer;

begin
  for n := 0 to lvP.Items.Count - 1 do
    lvP.Items[n].Checked := false;

  lvP.SetFocus;
end;

{$I+}
procedure TfrmPreview.ApplyChanges;

var n : integer;
    i : TListItem;
    nSize : comp;

begin
  bBusy := true;
  prg.Max := lvP.Items.Count;

  for n := 0 to lvP.Items.Count - 1 do
  begin
    if bCancel then break;
    prg.Position := n + 1;
    i := lvP.Items[n];
    lblMsg.Caption := ExtractFileName(i.Caption);
    Application.ProcessMessages;

    if i.Checked then
    begin
      Work.slSkip.Delete(Work.slSkip.IndexOf(i.Caption));

      if (not frmMain.chkNoCopy.Checked) and
       (not CopyFile(i.Caption,i.SubItems[0])) then
        Work.slErr.Add(i.Caption)
      else
      begin
        Work.slOk.Add(i.Caption);
        nSize := VPAExt.GetFileSize(i.Caption);
        Work.nOkBytes := Work.nOkBytes + nSize;
        Work.nSkipBytes := Work.nSkipBytes - nSize;
      end;
    end;
  end;

  frmMain.UpdateCounts;
  Close;
end;

procedure TfrmPreview.cmdSaveListClick(Sender: TObject);

var n : integer;
    txt : textfile;

begin
  if not dlgSave.Execute then exit;
  AssignFile(txt,dlgSave.FileName);
  Rewrite(txt);
  WriteLn(txt,c_App + ' ' + c_Ver);
  WriteLn(txt,c_Copyright);
  WriteLn(txt,c_URL + CRLF);
  WriteLn(txt,'Confirmation List (checked items marked with +)' + CRLF);

  for n := 0 to lvP.Items.Count - 1 do
  begin
    if lvP.Items[n].Checked then
      Write(txt,'+ ')
    else
      Write(txt,'  ');

    WriteLn(txt,lvP.Items[n].Caption);
  end;

  CloseFile(txt);
  RunAssoc(dlgSave.FileName);
end;

end.
