unit SkipList;

interface

uses Windows,Messages,SysUtils,Variants,Classes,Graphics,
     Controls,Forms,Dialogs,ComCtrls,StdCtrls,ExtCtrls;

type TfrmSkipList = class(TForm)
       pnlButtons: TPanel;
       cmdAddFolder: TButton;
       cmdAddFiles: TButton;
       edtRemove: TButton;
       cmdDone: TButton;
       pnlList: TPanel;
       lvSkip: TListView;
       dlgFiles: TOpenDialog;
       procedure FormKeyPress(Sender: TObject; var Key: Char);
       procedure cmdAddFilesClick(Sender: TObject);
       procedure cmdAddFolderClick(Sender: TObject);
       procedure edtRemoveClick(Sender: TObject);
       procedure cmdDoneClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
     private
       procedure DropMsg(var msg : TWMDropFiles); message WM_DROPFILES;
     public
     end;

var frmSkipList : TfrmSkipList;

implementation

{$R *.dfm}

uses VPAExt,ShellAPI;

procedure TfrmSkipList.FormCreate(Sender: TObject);
begin
  DragAcceptFiles(Handle,true);
end;

procedure TfrmSkipList.DropMsg(var msg : TWMDropFiles);

var n,nFile : integer;
    Files : array[0..255] of char;
    FName : string;
    i : TListItem;

begin
  nFile := DragQueryFile(Msg.Drop,$FFFFFFFF,Files,0);
  lvSkip.Items.BeginUpdate;

  try
    for n := 0 to nFile - 1 do
    begin
      FName := copy(Files,0,DragQueryFile(Msg.Drop,n,Files,255));

      if lvSkip.FindCaption(0,FName,false,true,false) = nil then
      begin
        i := lvSkip.Items.Add;
        i.Caption := FName;
      end;
    end;
  finally
    Msg.Result := 0;
    DragFinish(msg.Drop);
    lvSkip.Items.EndUpdate;
  end;
end;

procedure TfrmSkipList.FormKeyPress(Sender: TObject; var Key: Char);
begin
  if Key = #27 then Close;
end;

procedure TfrmSkipList.cmdAddFilesClick(Sender: TObject);

var n : integer;
    i : TListItem;

begin
  if dlgFiles.Execute then
  begin
    for n := 0 to dlgFiles.Files.Count - 1 do
    begin
      if lvSkip.FindCaption(0,dlgFiles.Files[n],false,true,false) = nil then
      begin
        i := lvSkip.Items.Add;
        i.Caption := dlgFiles.Files[n];
      end;
    end;
  end;
end;

procedure TfrmSkipList.cmdAddFolderClick(Sender: TObject);

var s : string;
    i : TListItem;

begin
  s := GetDirectory('Skip Folder');
  if s = '' then exit;
  s := FinalBS(s); // signals dir vs filespec

  if lvSkip.FindCaption(0,s,false,true,false) = nil then
  begin
    i := lvSkip.Items.Add;
    i.Caption := s;
  end;
end;

procedure TfrmSkipList.edtRemoveClick(Sender: TObject);
begin
  lvSkip.DeleteSelected;
end;

procedure TfrmSkipList.cmdDoneClick(Sender: TObject);
begin
  Close;
end;

end.
