/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.differentiation;

import com.numericalmethod.suanshu.Constant;
import com.numericalmethod.suanshu.analysis.differentiation.univariate.FiniteDifference;
import com.numericalmethod.suanshu.analysis.function.rn2r1.BivariateRealFunction;
import com.numericalmethod.suanshu.analysis.function.rn2r1.RealScalarFunction;
import com.numericalmethod.suanshu.analysis.function.rn2r1.UnivariateRealFunction;
import com.numericalmethod.suanshu.analysis.interpolation.NevilleTable;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;
import java.util.Arrays;

public class Ridders
implements RealScalarFunction {
    public static final int N_POINTS_4_EXTRAPOLATION = 15;
    public final int nPoints4Extrapolation;
    public final int order;
    public final RealScalarFunction f;
    public final double rate;
    private NevilleTable m;
    private RealScalarFunction H;

    public int dimension4Domain() {
        return this.f.dimension4Domain();
    }

    public Ridders(RealScalarFunction f, int[] varidx) {
        this(f, varidx, 0.75, 15);
    }

    public Ridders(final RealScalarFunction f, final int[] varidx, double rate, int nPoints4Extrapolation) {
        this.f = f;
        this.order = varidx.length;
        this.rate = rate;
        this.nPoints4Extrapolation = nPoints4Extrapolation;
        this.H = new RealScalarFunction(){
            com.numericalmethod.suanshu.analysis.differentiation.multivariate.FiniteDifference df;
            {
                2 a2;
                a2.df = new com.numericalmethod.suanshu.analysis.differentiation.multivariate.FiniteDifference(a2.f, a2.varidx);
            }

            public int dimension4Range() {
                return 1;
            }

            public int dimension4Domain() {
                return f.dimension4Domain() + 1;
            }

            public double evaluate(double ... z2) {
                double a2 = z2[z2.length - 1];
                double[] a3 = Arrays.copyOfRange(z2, 0, z2.length - 1);
                return this.df.evaluate(a3, a2);
            }
        };
    }

    public double evaluate(double[] x2, double h2) {
        int a2;
        double a3 = h2;
        double[] dArray = Arrays.copyOf(x2, x2.length + 1);
        double[] a4 = dArray;
        dArray[a4.length - 1] = a3;
        double a5 = this.H.evaluate(a4);
        this.m = new NevilleTable();
        double[] dArray2 = new double[1];
        dArray2[0] = a3;
        double[] dArray3 = new double[1];
        dArray3[0] = a5;
        this.m.addData(dArray2, dArray3);
        double a6 = a5;
        double a7 = Double.MAX_VALUE;
        double a8 = a3;
        int n = a2 = 2;
        while (n <= this.nPoints4Extrapolation) {
            a8 *= this.rate;
            double[] dArray4 = Arrays.copyOf(x2, x2.length + 1);
            a4 = dArray4;
            dArray4[a4.length - 1] = a8;
            double a9 = this.H.evaluate(a4);
            double[] dArray5 = new double[1];
            dArray5[0] = a8;
            double[] dArray6 = new double[1];
            dArray6[0] = a9;
            this.m.addData(dArray5, dArray6);
            this.m.evaluate(0.0);
            int n2 = a2 - 2;
            while (n2 >= 0) {
                double d2;
                int a10;
                double a11 = this.m.get(a10, a2 - 1);
                double a12 = Math.abs(a11 - this.m.get(a10, a2 - 2));
                double a13 = Math.abs(a11 - this.m.get(a10 + 1, a2 - 1));
                double a14 = Math.max(a12, a13);
                if (d2 < a7) {
                    a6 = a11;
                    a7 = a14;
                }
                n2 = --a10;
            }
            if (Math.abs(a9 - this.m.get(a2 - 2, a2 - 2)) > 2.0 * a7) break;
            n = ++a2;
        }
        return a6;
    }

    public double evaluate(double ... x2) {
        double a2 = new DenseVector(x2).norm();
        double a3 = 15.0 * Math.pow(Constant.EPSILON, 1.0 / (double)(this.order + 1)) * Math.max(0.1, a2);
        return this.evaluate(x2, a3);
    }

    public Ridders(UnivariateRealFunction f, int order) {
        this(f, order, 0.75, 15);
    }

    public Ridders(final UnivariateRealFunction f, final int order, double rate, int nPoints4Extrapolation) {
        SuanShuUtils.assertArgument(order > 0, b.C("a|s5~fvpo4qs9p\u007fglbgahbg5`a}a)vo5\u000b)\u0016d"));
        this.f = f;
        this.order = order;
        this.rate = rate;
        this.nPoints4Extrapolation = nPoints4Extrapolation;
        this.H = new BivariateRealFunction(){
            FiniteDifference df;
            {
                1 a2;
                a2.df = new FiniteDifference(a2.f, a2.order, FiniteDifference.Type.CENTRAL);
            }

            public double evaluate(double x2, double h2) {
                double[] dArray = new double[1];
                dArray[0] = x2;
                return this.df.evaluate(dArray, h2);
            }

            public double evaluate(double ... z2) {
                double a2 = z2[0];
                double a3 = z2[1];
                double[] dArray = new double[1];
                dArray[0] = a2;
                return this.df.evaluate(dArray, a3);
            }
        };
    }

    public int dimension4Range() {
        return 1;
    }
}

