/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.differentiation.multivariate;

import com.numericalmethod.suanshu.Constant;
import com.numericalmethod.suanshu.analysis.function.rn2r1.RealScalarFunction;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;
import java.util.Arrays;

public class FiniteDifference
implements RealScalarFunction {
    public final RealScalarFunction f;
    private final int[] H;

    public int dimension4Range() {
        return 1;
    }

    public double evaluateByRecursion(int n, double h2, double ... z2) {
        double[] a2 = Arrays.copyOf(z2, z2.length);
        if (n == 1) {
            int n2 = this.H[0] - 1;
            a2[n2] = a2[n2] + h2;
            double a3 = this.f.evaluate(a2);
            int n3 = this.H[0] - 1;
            a2[n3] = a2[n3] - 2.0 * h2;
            double a4 = this.f.evaluate(a2);
            double a5 = (a3 - a4) / 2.0 / h2;
            return a5;
        }
        int n4 = this.H[n - 1] - 1;
        a2[n4] = a2[n4] + h2;
        double a6 = this.evaluateByRecursion(n - 1, h2, a2);
        int n5 = this.H[n - 1] - 1;
        a2[n5] = a2[n5] - 2.0 * h2;
        double a7 = this.evaluateByRecursion(n - 1, h2, a2);
        double a8 = (a6 - a7) / 2.0 / h2;
        return a8;
    }

    public double evaluate(double[] x2, double h2) {
        return this.evaluateByRecursion(this.H.length, h2, x2);
    }

    public double evaluate(double ... x2) {
        DenseVector a2 = new DenseVector(x2);
        double a3 = Math.pow(Constant.MACH_EPS, 1.0 / (double)(this.H.length + 1)) * Math.max(0.1, a2.norm());
        return this.evaluate(x2, a3);
    }

    public int dimension4Domain() {
        return this.f.dimension4Domain();
    }

    public FiniteDifference(RealScalarFunction f, int[] varidx) {
        int a2;
        this.f = f;
        int n = a2 = 0;
        while (n < varidx.length) {
            if (varidx[a2] < 1 || varidx[a2] > f.dimension4Domain()) {
                throw new IllegalArgumentException(b.C("|z`t}}v5kul|xvvp%gvpb}d|nuz|fz15ZfRpC4AeXwWsP}_f\u0005bGgHu@yH4G{M}Ip&"));
            }
            n = ++a2;
        }
        this.H = Arrays.copyOf(varidx, varidx.length);
    }
}

