/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.differentiation.univariate;

import com.numericalmethod.suanshu.analysis.differentiation.Ridders;
import com.numericalmethod.suanshu.analysis.differentiation.univariate.DBetaRegularized;
import com.numericalmethod.suanshu.analysis.differentiation.univariate.DErf;
import com.numericalmethod.suanshu.analysis.differentiation.univariate.DGamma;
import com.numericalmethod.suanshu.analysis.differentiation.univariate.DGaussian;
import com.numericalmethod.suanshu.analysis.differentiation.univariate.DPolynomial;
import com.numericalmethod.suanshu.analysis.differentiation.univariate.FiniteDifference;
import com.numericalmethod.suanshu.analysis.function.polynomial.Polynomial;
import com.numericalmethod.suanshu.analysis.function.rn2r1.RealScalarFunction;
import com.numericalmethod.suanshu.analysis.function.rn2r1.UnivariateRealFunction;
import com.numericalmethod.suanshu.analysis.function.special.BetaRegularized;
import com.numericalmethod.suanshu.analysis.function.special.CumulativeNormal;
import com.numericalmethod.suanshu.analysis.function.special.Digamma;
import com.numericalmethod.suanshu.analysis.function.special.Erf;
import com.numericalmethod.suanshu.analysis.function.special.Gamma;
import com.numericalmethod.suanshu.analysis.function.special.Gaussian;
import com.numericalmethod.suanshu.analysis.function.special.LogGamma;

public class Dfdx
extends UnivariateRealFunction {
    private final UnivariateRealFunction H;

    public Dfdx(UnivariateRealFunction f) {
        this(f, Method.FINITE_DIFFERENCE);
    }

    public Dfdx(final UnivariateRealFunction f, Method method) {
        if (f instanceof Polynomial) {
            this.H = new DPolynomial((Polynomial)f);
        } else if (f instanceof BetaRegularized) {
            this.H = new DBetaRegularized(((BetaRegularized)f).p, ((BetaRegularized)f).q);
        } else if (f instanceof LogGamma) {
            this.H = new Digamma();
        } else if (f instanceof Gamma) {
            this.H = new DGamma();
        } else if (f instanceof CumulativeNormal) {
            this.H = new Gaussian();
        } else if (f instanceof Gaussian) {
            this.H = new DGaussian((Gaussian)f);
        } else if (f instanceof Erf) {
            this.H = new DErf();
        } else {
            switch (method) {
                case RIDDERS: {
                    do {
                    } while (false);
                    this.H = new UnivariateRealFunction(){
                        RealScalarFunction df;
                        {
                            1 a2;
                            a2.df = new Ridders(a2.f, 1);
                        }

                        public double evaluate(double x2) {
                            double[] dArray = new double[1];
                            dArray[0] = x2;
                            return this.df.evaluate(dArray);
                        }
                    };
                    break;
                }
                default: {
                    this.H = new FiniteDifference(f, 1, FiniteDifference.Type.CENTRAL);
                }
            }
        }
    }

    public double evaluate(double x2) {
        return this.H.evaluate(x2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Method
    extends Enum<Method> {
        public static final /* enum */ Method FINITE_DIFFERENCE = new Method();
        private static final /* synthetic */ Method[] $VALUES;
        public static final /* enum */ Method RIDDERS = new Method();

        public static Method valueOf(String name) {
            return Enum.valueOf(Method.class, name);
        }

        static {
            Method[] methodArray = new Method[2];
            methodArray[0] = FINITE_DIFFERENCE;
            methodArray[1] = RIDDERS;
            $VALUES = methodArray;
        }

        public static Method[] values() {
            return (Method[])$VALUES.clone();
        }

        private Method() {
            Method a2;
        }
    }
}

