/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.differentiation.univariate;

import com.numericalmethod.suanshu.Constant;
import com.numericalmethod.suanshu.analysis.function.FunctionOps;
import com.numericalmethod.suanshu.analysis.function.rn2r1.UnivariateRealFunction;
import com.numericalmethod.suanshu.misc.SuanShuUtils;

public class FiniteDifference
extends UnivariateRealFunction {
    public final UnivariateRealFunction f;
    private volatile double H;
    public final Type type;
    public final int order;

    public FiniteDifference(UnivariateRealFunction f, int order, Type type) {
        SuanShuUtils.assertArgument(order > 0, b.C("a|s5~fvpo4qs9p\u007fglbgahbg5`a}a)vo5\u000b)\u0016d"));
        this.order = order;
        this.type = type;
        this.f = f;
    }

    public double df(double x2, double h2) {
        int a2;
        double a3 = 0.0;
        int a4 = 1;
        int n = a2 = 0;
        while (n <= this.order) {
            double a5 = x2;
            switch (this.type) {
                case FORWARD: {
                    a5 += (double)(this.order - a2) * h2;
                    break;
                }
                case BACKWARD: {
                    a5 += (double)(-a2) * h2;
                    break;
                }
                case CENTRAL: {
                    do {
                    } while (false);
                    a5 += ((double)this.order / 2.0 - (double)a2) * h2;
                }
            }
            a3 += (double)a4 * FunctionOps.combination(this.order, a2) * this.f.evaluate(a5);
            a4 *= -1;
            n = ++a2;
        }
        return a3;
    }

    public double evaluate(double[] x2, double h2) {
        double a2 = x2[0];
        this.H = a2 + h2;
        h2 = this.H - a2;
        double a3 = this.df(a2, h2);
        if (this.order % 2 == 1 && this.type == Type.CENTRAL) {
            a3 = 0.5 * (this.df(a2 - h2 / 2.0, h2) + this.df(a2 + h2 / 2.0, h2));
        }
        return a3 / Math.pow(h2, this.order);
    }

    public double evaluate(double x2) {
        double a2 = Math.pow(Constant.MACH_EPS, 1.0 / (double)(this.order + 1)) * Math.max(0.1, Math.abs(x2));
        double[] dArray = new double[1];
        dArray[0] = x2;
        return this.evaluate(dArray, a2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type BACKWARD;
        public static final /* enum */ Type FORWARD;
        public static final /* enum */ Type CENTRAL;
        private static final /* synthetic */ Type[] $VALUES;

        private Type() {
            Type a2;
        }

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        static {
            FORWARD = new Type();
            BACKWARD = new Type();
            CENTRAL = new Type();
            Type[] typeArray = new Type[3];
            typeArray[0] = FORWARD;
            typeArray[1] = BACKWARD;
            typeArray[2] = CENTRAL;
            $VALUES = typeArray;
        }

        public static Type valueOf(String name) {
            return Enum.valueOf(Type.class, name);
        }
    }
}

