/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.function.polynomial;

import com.numericalmethod.suanshu.analysis.function.polynomial.HornerScheme;
import com.numericalmethod.suanshu.analysis.function.rn2r1.UnivariateRealFunction;
import com.numericalmethod.suanshu.mathstructure.Ring;
import com.numericalmethod.suanshu.mathstructure.VectorSpace;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.number.Real;
import com.numericalmethod.suanshu.number.complex.Complex;
import com.numericalmethod.suanshu.number.complex.ElementaryFunction;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Polynomial
extends UnivariateRealFunction
implements Ring<Polynomial>,
VectorSpace<Polynomial, Real> {
    public static final Polynomial ONE;
    public static final Polynomial ZERO;
    public final int degree;
    private final double[] H;

    public String toString() {
        int a2;
        StringBuilder a3 = new StringBuilder();
        int n = a2 = 0;
        while (n <= this.degree) {
            if (this.H[a2] != 0.0) {
                if (a2 > 0 && this.H[a2] >= 0.0) {
                    a3.append(b.C("~"));
                }
                Object[] objectArray = new Object[1];
                objectArray[0] = this.H[a2];
                a3.append(String.format(b.C("0:$3"), objectArray));
                if (a2 != this.degree) {
                    Object[] objectArray2 = new Object[1];
                    objectArray2[0] = this.degree - a2;
                    a3.append(String.format(b.C("<mI1t|"), objectArray2));
                }
            }
            n = ++a2;
        }
        return a3.toString();
    }

    public int hashCode() {
        int a2 = 7;
        a2 = 71 * a2 + this.degree;
        a2 = 71 * a2 + (this.H != null ? this.H.hashCode() : 0);
        return a2;
    }

    public Complex evaluate(Number x2) {
        if (x2 instanceof Double) {
            double a2 = this.evaluate(x2.doubleValue());
            return new Complex(a2, 0.0);
        }
        if (x2 instanceof Complex) {
            return this.evaluate((Complex)x2);
        }
        throw new UnsupportedOperationException(b.C("`zdpr{u{tn{q9Zoxgqt5umr0"));
    }

    @Override
    public Polynomial ZERO() {
        return ZERO;
    }

    public Polynomial normalize() {
        int a2;
        double[] a3 = Arrays.copyOf(this.H, this.H.length);
        double a4 = a3[0];
        int n = a2 = 1;
        while (n < a3.length) {
            int n2 = a2++;
            a3[n2] = a3[n2] / a4;
            n = a2;
        }
        a3[0] = 1.0;
        return new Polynomial(a3);
    }

    @Override
    public Polynomial multiply(Polynomial that) {
        int a2;
        double[] a3 = new double[this.degree + that.degree + 1];
        int n = a2 = 0;
        while (n < a3.length) {
            int a4;
            a3[a2] = 0.0;
            int n2 = a4 = 0;
            while (n2 <= a2) {
                int n3 = a2;
                a3[n3] = a3[n3] + that.coefficient(a4) * this.coefficient(a2 - a4);
                n2 = ++a4;
            }
            n = ++a2;
        }
        return new Polynomial(a3);
    }

    static {
        double[] dArray = new double[1];
        dArray[0] = 0.0;
        ZERO = new Polynomial(dArray);
        double[] dArray2 = new double[1];
        dArray2[0] = 1.0;
        ONE = new Polynomial(dArray2);
    }

    public Polynomial(double ... coefficients) {
        int a2;
        int a3 = coefficients.length - 1;
        int n = a2 = 0;
        while (true) {
            if (n >= coefficients.length - 1 || coefficients[a2] != 0.0) break;
            --a3;
            n = ++a2;
        }
        this.degree = a3;
        this.H = Arrays.copyOfRange(coefficients, coefficients.length - this.degree - 1, coefficients.length);
    }

    public Complex evaluate(Complex z2) {
        int a2;
        Object a3 = z2.ZERO();
        int n = a2 = 0;
        while (n <= this.degree) {
            a3 = ((Complex)a3).add(ElementaryFunction.pow(z2, new Complex(this.degree - a2, 0.0)).multiply(new Complex(this.H[a2], 0.0)));
            n = ++a2;
        }
        return a3;
    }

    @Override
    public Polynomial scaled(double scalar) {
        int a2;
        double[] a3 = new double[this.H.length];
        int n = a2 = 0;
        while (n < a3.length) {
            a3[a2] = scalar * this.H[a2];
            n = ++a2;
        }
        return new Polynomial(a3);
    }

    public double[] coefficients() {
        return Arrays.copyOf(this.H, this.H.length);
    }

    @Override
    @Deprecated
    public Polynomial scaled(Real scalar) {
        throw new UnsupportedOperationException(b.C("Zzc4c`cdsgkq|5bqp{"));
    }

    @Override
    public double evaluate(double x2) {
        if (this.degree == 0) {
            return this.H[0];
        }
        return new HornerScheme(this, x2).remainder();
    }

    @Override
    public Polynomial add(Polynomial that) {
        int a2;
        double[] a3 = null;
        double[] a4 = null;
        if (this.degree > that.degree) {
            a3 = this.H;
            a4 = that.H;
        } else {
            a3 = that.H;
            a4 = this.H;
        }
        double[] a5 = new double[a3.length];
        int a6 = a3.length - a4.length;
        System.arraycopy(a3, 0, a5, 0, a6);
        int n = a2 = 0;
        while (n < a4.length) {
            a5[a6 + a2] = a3[a6 + a2] + a4[a2];
            n = ++a2;
        }
        return new Polynomial(a5);
    }

    public double coefficient(int i2) {
        if (i2 < 0) {
            throw new IllegalArgumentException(b.C("wzrrv|p}y{k4q{\u007fq|5jasa#vi5a{f8eqStC}F0"));
        }
        return i2 < this.H.length ? this.H[i2] : 0.0;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Polynomial)) {
            return false;
        }
        Polynomial a2 = (Polynomial)obj;
        if (this.degree != a2.degree) {
            return false;
        }
        if (!(this.H == a2.H || this.H != null && DoubleUtils.equal(this.H, a2.H, 0.0))) {
            return false;
        }
        return true;
    }

    @Override
    public Polynomial ONE() {
        return ONE;
    }

    @Override
    public Polynomial opposite() {
        int a2;
        double[] a3 = new double[this.H.length];
        int n = a2 = 0;
        while (n <= this.degree) {
            a3[a2] = -this.H[a2];
            n = ++a2;
        }
        return new Polynomial(a3);
    }

    @Override
    public Polynomial minus(Polynomial that) {
        return this.add((Polynomial)that.opposite());
    }
}

