/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.function.polynomial.root;

import com.numericalmethod.suanshu.analysis.function.polynomial.Polynomial;
import com.numericalmethod.suanshu.analysis.function.polynomial.root.QuarticByFormula;
import com.numericalmethod.suanshu.analysis.function.polynomial.root.Solver;
import com.numericalmethod.suanshu.datastructure.list.NumberList;
import com.numericalmethod.suanshu.misc.SuanShuUtils;

public class Quartic
implements Solver {
    private final QuarticSolver H;

    public Solver.Type type() {
        return Solver.Type.QUARTIC;
    }

    public Quartic(QuarticSolver solver) {
        this.H = solver;
    }

    public NumberList solve(Polynomial polynomial) {
        SuanShuUtils.assertArgument(polynomial.degree == 4, b.C("ygfpcgc``d\"`v(hfm(uo=l{ncmw)a"));
        double[] a2 = polynomial.coefficients();
        return this.H.solve(a2[0], a2[1], a2[2], a2[3], a2[4]);
    }

    public Quartic() {
        this(new QuarticByFormula());
    }

    public static interface QuarticSolver {
        public NumberList solve(double var1, double var3, double var5, double var7, double var9);
    }
}

