/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.function.polynomial.root;

import com.numericalmethod.suanshu.analysis.function.polynomial.root.Quartic;
import com.numericalmethod.suanshu.datastructure.list.NumberList;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.number.complex.Complex;
import com.numericalmethod.suanshu.number.complex.ElementaryFunction;

public class QuarticByFerrari
implements Quartic.QuarticSolver {
    private static final double H = 0.3333333333333333;

    public NumberList solve(double a2, double b2, double c2, double d2, double e2) {
        double[] dArray = new double[5];
        dArray[0] = a2;
        dArray[1] = b2;
        dArray[2] = c2;
        dArray[3] = d2;
        dArray[4] = e2;
        double a3 = SuanShuUtils.autoEpsilon(dArray);
        return this.solve(a2, b2, c2, d2, e2, a3);
    }

    public NumberList solve(double a2, double b2, double c2, double d2, double e2, double epsilon) {
        NumberList a3 = new NumberList();
        double a4 = a2 * a2;
        double a5 = a4 * a2;
        double a6 = a4 * a4;
        double a7 = b2 * b2;
        double a8 = a7 * b2;
        double a9 = a7 * a7;
        double a10 = b2 * c2;
        double a11 = a7 * c2;
        double a12 = -3.0 * a7 / 8.0 / a4 + c2 / a2;
        double a13 = a8 / 8.0 / a5 - a10 / 2.0 / a4 + d2 / a2;
        double a14 = -3.0 * a9 / 256.0 / a6 + a11 / 16.0 / a5 - b2 * d2 / 4.0 / a4 + e2 / a2;
        if (DoubleUtils.equal(a13, 0.0, epsilon)) {
            double a15 = a12 * a12 - 4.0 * a14;
            Complex a16 = new Complex(-b2 / a2 / 4.0, 0.0);
            Complex a17 = new Complex(-a12 / 2.0, 0.0);
            Complex a18 = ElementaryFunction.sqrt(new Complex(a15 / 4.0, 0.0));
            a3.add(a16.add(ElementaryFunction.sqrt(a17.add(a18))));
            a3.add(a16.add(ElementaryFunction.sqrt(a17.minus(a18))));
            a3.add(a16.minus(ElementaryFunction.sqrt(a17.add(a18))));
            a3.add(a16.minus(ElementaryFunction.sqrt(a17.minus(a18))));
        } else {
            double a19 = a12 * a12;
            double a20 = a19 * a12;
            double a21 = -a19 / 12.0 - a14;
            double a22 = -a20 / 108.0 + a12 * a14 / 3.0 - a13 * a13 / 8.0;
            double a23 = a21 * a21 * a21;
            double a24 = a22 * a22;
            Complex a25 = ElementaryFunction.pow(new Complex(-a22 / 2.0, 0.0).add(ElementaryFunction.sqrt(new Complex(a24 / 4.0 + a23 / 27.0, 0.0))), new Complex(0.3333333333333333, 0.0));
            Complex a26 = new Complex(-5.0 * a12 / 6.0, 0.0).add(a25).minus(a25.equals(a25.ZERO()) ? ElementaryFunction.pow(new Complex(a22, 0.0), new Complex(0.3333333333333333, 0.0)) : new Complex(a21 / 3.0, 0.0).divide(a25));
            Complex a27 = ElementaryFunction.sqrt(new Complex(a12, 0.0).add(new Complex(a26.real * 2.0, a26.imaginary * 2.0)));
            Complex a28 = new Complex(-b2 / 4.0 / a2, 0.0);
            Complex a29 = new Complex(a27.real / 2.0, a27.imaginary / 2.0);
            Complex a30 = new Complex(3.0 * a12 / 4.0 + a26.real / 2.0, a26.imaginary / 2.0);
            Complex a31 = new Complex(a13 / 2.0, 0.0).divide(a27);
            Complex a32 = ElementaryFunction.sqrt((Complex)a30.add(a31).opposite());
            Complex a33 = ElementaryFunction.sqrt((Complex)a30.minus(a31).opposite());
            a3.add(a28.add(a29).add(a32));
            a3.add(a28.add(a29).minus(a32));
            a3.add(a28.minus(a29).add(a33));
            a3.add(a28.minus(a29).minus(a33));
        }
        return a3;
    }
}

