/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.function.polynomial.root.jenkinstraub;

import com.numericalmethod.suanshu.Constant;
import com.numericalmethod.suanshu.analysis.function.polynomial.HornerScheme;
import com.numericalmethod.suanshu.analysis.function.polynomial.Polynomial;
import com.numericalmethod.suanshu.analysis.function.polynomial.QuadraticSyntheticDivision;
import com.numericalmethod.suanshu.analysis.uniroot.Newton;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.number.DoubleUtils;

class JtUtil {
    private static final double M = Double.MIN_VALUE / Constant.MACH_EPS;
    private static final double m = Math.log(2.0);
    private static final double H = 2.0;

    static Polynomial scaleForAvoidingOverflowUnderflow(Polynomial a2) {
        double d2;
        int a3;
        double[] a4 = a2.coefficients();
        double a5 = 0.0;
        double a6 = Double.MAX_VALUE;
        double a7 = 0.0;
        int n = a3 = 0;
        while (n < a4.length) {
            double d3;
            a7 = Math.abs(a4[a3]);
            if (d3 > a5) {
                a5 = a7;
            }
            if (a7 != 0.0 && a7 < a6) {
                a6 = a7;
            }
            n = ++a3;
        }
        double a22 = M / a6;
        if (d2 <= 1.0 && a5 >= 10.0 || a22 > 1.0 && Double.MAX_VALUE / a22 >= a5) {
            int a8;
            if (a22 == 0.0) {
                a22 = Double.MIN_VALUE;
            }
            if ((a8 = (int)Math.floor(Math.log(a22) / m + 0.5)) != 0) {
                double a9 = Math.pow(2.0, a8);
                return a2.scaled(a9);
            }
        }
        return a2;
    }

    static VarSet computeScalarsForNextK(Polynomial a2, double a3, double a4, double a5, double a6) {
        double d2;
        double a7 = 0.0;
        double a8 = 0.0;
        double a9 = 0.0;
        double a10 = 0.0;
        double a11 = 0.0;
        double a12 = 0.0;
        double a13 = 0.0;
        double a14 = 0.0;
        double a15 = 0.0;
        QuadraticSyntheticDivision a16 = new QuadraticSyntheticDivision(a2, a5, a6);
        Polynomial a17 = a16.quotient();
        a11 = a16.b();
        a10 = a16.a();
        if (Math.abs(d2) <= 100.0 * Constant.MACH_EPS * Math.abs(a2.coefficient(a2.degree - 1))) {
            if (Math.abs(a11) <= 100.0 * Constant.MACH_EPS * Math.abs(a2.coefficient(a2.degree - 2))) {
                return new VarSet(VarSet.Type.UNSCALED, a7, a8, a9, a4, a3, a10, a11, a12, a13, a14, a15, a17);
            }
        }
        a15 = a6 * a3;
        if (Math.abs(a11) >= Math.abs(a10)) {
            a12 = a4 / a11;
            a13 = a10 / a11;
            a14 = a5 * a3;
            a8 = a12 * (a14 + a4) + a15 * (a3 / a11);
            a9 = a15 + (a13 + a5) * a4;
            a7 = -a4 + a13 * a3;
            return new VarSet(VarSet.Type.DIVIDED_BY_D, a7, a8, a9, a4, a3, a10, a11, a12, a13, a14, a15, a17);
        }
        a12 = a4 / a10;
        a13 = a11 / a10;
        a14 = a12 * a5;
        a8 = a12 * a4 + (a14 + a15 / a10) * a3;
        a9 = a14 * a11 + a15 * a13 + a4;
        a7 = -(a4 * (a11 / a10)) + a3;
        return new VarSet(VarSet.Type.DIVIDED_BY_C, a7, a8, a9, a4, a3, a10, a11, a12, a13, a14, a15, a17);
    }

    static double[] uvEstimate(Polynomial a2, Polynomial a3, VarSet a4, double a5, double a6) {
        double a7 = 0.0;
        double a8 = 0.0;
        switch (a4.type) {
            case UNSCALED: {
                double[] dArray = new double[2];
                dArray[0] = 0.0;
                dArray[1] = 0.0;
                return dArray;
            }
            case DIVIDED_BY_C: {
                a7 = a4.a + a5 * a4.b + a4.h * a4.f;
                a8 = a4.c + (a5 + a6 * a4.f) * a4.d;
                break;
            }
            case DIVIDED_BY_D: {
                do {
                } while (false);
                a7 = (a4.a + a4.g) * a4.f + a4.h;
                a8 = (a4.f + a5) * a4.c + a6 * a4.d;
            }
        }
        double a9 = -a3.coefficient(a3.degree) / a2.coefficient(a2.degree);
        double a10 = -(a3.coefficient(a3.degree - 1) + a9 * a2.coefficient(a2.degree - 1)) / a2.coefficient(a2.degree);
        double a11 = a6 * a10 * a4.a1;
        double a12 = a9 * a4.a7;
        double a13 = a9 * a9 * a4.a3;
        double a14 = -(a12 + a13) + a11;
        double a15 = -a14 + a8 + a9 * a7;
        if (a15 != 0.0) {
            double[] dArray = new double[2];
            dArray[0] = -((a5 * (a13 + a12) + a6 * (a9 * a4.a1 + a10 * a4.a7)) / a15) + a5;
            dArray[1] = a6 * (1.0 + a14 / a15);
            return dArray;
        }
        double[] dArray = new double[2];
        dArray[0] = 0.0;
        dArray[1] = 0.0;
        return dArray;
    }

    JtUtil() {
        JtUtil a2;
    }

    static double estimateRootModulus(Polynomial a2) {
        int a3 = a2.degree;
        double[] a4 = DoubleUtils.abs(a2.coefficients());
        a4[a3] = -a4[a3];
        double a5 = Math.exp((Math.log(-a4[a3]) - Math.log(a4[0])) / (double)a3);
        double a6 = 0.0;
        if (a4[a3 - 1] != 0.0) {
            a6 = -a4[a3] / a4[a3 - 1];
            if (a6 < a5) {
                a5 = a6;
            }
        }
        Polynomial a7 = new Polynomial(a4);
        HornerScheme a8 = null;
        a6 = a5;
        while ((a8 = new HornerScheme(a7, a6 = 0.1 * (a5 = a6))).remainder() > 0.0) {
        }
        Newton a9 = new Newton(a7, SuanShuUtils.autoEpsilon(a4));
        return a9.solve(100, a5);
    }

    static Polynomial computeNextK(Polynomial a2, Polynomial a3, VarSet a4) {
        double a5;
        if (a4.type == VarSet.Type.UNSCALED) {
            return a4.qkPoly;
        }
        double d2 = a5 = a4.type == VarSet.Type.DIVIDED_BY_C ? a4.b : a4.a;
        if (Math.abs(a4.a1) > 10.0 * Constant.MACH_EPS * Math.abs(a5)) {
            double a6 = a4.a7 / a4.a1;
            double a7 = a4.a3 / a4.a1;
            double[] dArray = new double[2];
            dArray[0] = 1.0;
            dArray[1] = 0.0;
            double[] dArray2 = new double[1];
            dArray2[0] = a4.b;
            return a4.qkPoly.scaled(a7).add(a3.scaled(-a6)).add(a3.multiply(new Polynomial(dArray))).add(new Polynomial(dArray2));
        }
        return a4.qkPoly.scaled(a4.a3).add(a3.scaled(-a4.a7));
    }

    static class VarSet {
        final double a1;
        final double a3;
        final double d;
        final double a;
        final double h;
        final double f;
        final Type type;
        final double a7;
        final double c;
        final double e;
        final Polynomial qkPoly;
        final double g;
        final double b;

        VarSet(Type a2, double a3, double a4, double a5, double a6, double a7, double a8, double a9, double a10, double a11, double a12, double a13, Polynomial a14) {
            VarSet a15;
            a15.type = a2;
            a15.a1 = a3;
            a15.a3 = a4;
            a15.a7 = a5;
            a15.a = a6;
            a15.b = a7;
            a15.c = a8;
            a15.d = a9;
            a15.e = a10;
            a15.f = a11;
            a15.g = a12;
            a15.h = a13;
            a15.qkPoly = a14;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static final class Type
        extends Enum<Type> {
            public static final /* enum */ Type UNSCALED;
            public static final /* enum */ Type DIVIDED_BY_D;
            public static final /* enum */ Type DIVIDED_BY_C;
            private static final /* synthetic */ Type[] $VALUES;

            public static Type[] values() {
                return (Type[])$VALUES.clone();
            }

            static {
                DIVIDED_BY_C = new Type();
                DIVIDED_BY_D = new Type();
                UNSCALED = new Type();
                Type[] typeArray = new Type[3];
                typeArray[0] = DIVIDED_BY_C;
                typeArray[1] = DIVIDED_BY_D;
                typeArray[2] = UNSCALED;
                $VALUES = typeArray;
            }

            private Type() {
                Type a2;
            }

            public static Type valueOf(String name) {
                return Enum.valueOf(Type.class, name);
            }
        }
    }
}

