/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.function.special;

import com.numericalmethod.suanshu.analysis.function.rn2r1.ContinuedFraction;
import com.numericalmethod.suanshu.analysis.function.rn2r1.UnivariateRealFunction;
import com.numericalmethod.suanshu.analysis.function.special.LogBeta;
import com.numericalmethod.suanshu.number.DoubleUtils;

public class BetaRegularized
extends UnivariateRealFunction {
    public final double p;
    public final double q;
    private static final LogBeta m = new LogBeta();
    private final ContinuedFraction H;

    public BetaRegularized(final double p2, final double q) {
        this.p = p2;
        this.q = q;
        this.H = new ContinuedFraction(new ContinuedFraction.Partials(){
            {
                1 a2;
            }

            public double B(int n, double x2) {
                return 1.0;
            }

            public double A(int n, double x2) {
                double a2 = 0.0;
                if (n % 2 == 1) {
                    int a3 = (n - 1) / 2;
                    a2 = -(p2 + (double)a3) * (p2 + q + (double)a3);
                    a2 /= (p2 + (double)(2 * a3)) * (p2 + (double)(2 * a3) + 1.0);
                    a2 *= x2;
                } else {
                    int a4 = (n - 2) / 2;
                    a2 = (double)(a4 + 1) * (q - (double)a4 - 1.0);
                    a2 /= (p2 + (double)(2 * a4) + 1.0) * (p2 + (double)(2 * a4) + 2.0);
                    a2 *= x2;
                }
                return a2;
            }
        });
    }

    public double evaluate(double x2) {
        if (DoubleUtils.compare(x2, 0.0) == 0) {
            return 0.0;
        }
        if (DoubleUtils.compare(x2, 1.0) == 0) {
            return 1.0;
        }
        double a2 = (this.p + 1.0) / (this.p + this.q + 2.0);
        if (x2 > a2) {
            BetaRegularized a3 = new BetaRegularized(this.q, this.p);
            return 1.0 - a3.evaluate(1.0 - x2);
        }
        double a4 = this.p * Math.log(x2) + this.q * Math.log(1.0 - x2) - Math.log(this.p) - m.evaluate(this.p, this.q);
        a4 = Math.exp(a4);
        return a4 /= this.H.evaluate(x2);
    }
}

