/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.analysis.function.special;

import com.numericalmethod.suanshu.Constant;
import com.numericalmethod.suanshu.analysis.function.polynomial.Polynomial;
import com.numericalmethod.suanshu.analysis.function.rn2r1.UnivariateRealFunction;
import com.numericalmethod.suanshu.analysis.function.special.BetaRegularized;
import com.numericalmethod.suanshu.analysis.function.special.ErfInverse;
import com.numericalmethod.suanshu.analysis.function.special.LogBeta;
import com.numericalmethod.suanshu.analysis.uniroot.Halley;
import com.numericalmethod.suanshu.analysis.uniroot.Uniroot;
import com.numericalmethod.suanshu.number.DoubleUtils;

public class BetaRegularizedInverse
extends UnivariateRealFunction {
    private final LogBeta m = new LogBeta();
    public final double p;
    private final ErfInverse H = new ErfInverse();
    public final double q;

    public double evaluate(final double u2) {
        double a2;
        double d2;
        if (DoubleUtils.compare(u2, 0.0) == 0) {
            return 0.0;
        }
        if (DoubleUtils.compare(u2, 1.0) == 0) {
            return 1.0;
        }
        double a3 = this.e(this.p, this.q, u2);
        if (d2 < 1.0E-300) {
            a3 = 1.0E-300;
        } else if (a3 > 0.999999999999999) {
            a3 = 0.999999999999999;
        }
        UnivariateRealFunction a4 = new UnivariateRealFunction(){
            {
                1 a2;
            }

            public double evaluate(double x2) {
                return new BetaRegularized(BetaRegularizedInverse.this.p, BetaRegularizedInverse.this.q).evaluate(x2) - u2;
            }
        };
        UnivariateRealFunction a5 = new UnivariateRealFunction(){
            {
                2 a2;
            }

            public double evaluate(double x2) {
                return Math.exp((BetaRegularizedInverse.this.p - 1.0) * Math.log(x2) + (BetaRegularizedInverse.this.q - 1.0) * Math.log(1.0 - x2) - BetaRegularizedInverse.this.m.evaluate(BetaRegularizedInverse.this.p, BetaRegularizedInverse.this.q));
            }
        };
        UnivariateRealFunction a6 = new UnivariateRealFunction(){
            {
                3 a2;
            }

            public double evaluate(double x2) {
                double a2 = (BetaRegularizedInverse.this.p - 2.0) * Math.log(x2) + (BetaRegularizedInverse.this.q - 2.0) * Math.log(1.0 - x2) - BetaRegularizedInverse.this.m.evaluate(BetaRegularizedInverse.this.p, BetaRegularizedInverse.this.q);
                a2 = Math.exp(a2);
                return a2 *= (BetaRegularizedInverse.this.p - 1.0) * (1.0 - x2) + (BetaRegularizedInverse.this.q - 1.0) * x2;
            }
        };
        Halley a7 = new Halley(a4, a5, a6, 1.0E-16);
        try {
            a2 = a7.solve(50, 0.0, 1.0, a3);
        }
        catch (Uniroot.NoRootFoundException a8) {
            a2 = a8.x;
        }
        return a2;
    }

    private double e(double a2, double a3, double a4) {
        BetaRegularizedInverse a5;
        if (a4 > 0.5) {
            return 1.0 - a5.e(a3, a2, 1.0 - a4);
        }
        return a5.C(a2, a3, a4);
    }

    private double C(double a2, double a3, double a4) {
        double a5 = 0.0;
        double a6 = Math.sqrt(-Math.log(a4 * a4));
        double a7 = a6 - (2.30753 + 0.27061 * a6) / (1.0 + (0.99229 + 0.04481 * a6) * a6);
        if (a2 > 1.0 && a3 > 1.0) {
            double a8 = (a7 * a7 - 3.0) / 6.0;
            double a9 = 1.0 / (2.0 * a2 - 1.0);
            double a10 = 1.0 / (2.0 * a3 - 1.0);
            double a11 = 2.0 / (a9 + a10);
            double a12 = a7 * Math.sqrt(a11 + a8) / a11 - (a10 - a9) * (a8 + 0.0 - 2.0 / (3.0 * a11));
            a5 = a2 / (a2 + a3 * Math.exp(a12 + a12));
        } else {
            BetaRegularizedInverse a13;
            double d2;
            double a14 = 2.0 * a3;
            double a15 = 1.0 / (9.0 * a3);
            a15 = a14 * Math.pow(1.0 - a15 + a7 * Math.sqrt(a15), 3.0);
            if (d2 <= 0.0) {
                a5 = 1.0 - Math.exp((Math.log((1.0 - a4) * a3) + a13.m.evaluate(a2, a3)) / a3);
            } else {
                double d3;
                double a16 = (4.0 * a2 + a14 - 2.0) / a15;
                a5 = d3 <= 1.0 ? Math.exp((Math.log(a4 * a2) + a13.m.evaluate(a2, a3)) / a2) : 1.0 - 2.0 / (a16 + 1.0);
            }
        }
        return a5;
    }

    public BetaRegularizedInverse(double p2, double q) {
        this.p = p2;
        this.q = q;
    }

    private double H(double a2, double a3, double a4) {
        BetaRegularizedInverse a5;
        double a6 = a3 - a2;
        double a7 = -a5.H.evaluate(1.0 - 2.0 * a4) / Math.sqrt(a2 / 2.0);
        double a8 = a6 * a6;
        double[] dArray = new double[5];
        dArray[0] = -a6 * Constant.ROOT_2 / 3840.0;
        dArray[1] = -0.005208333333333333;
        dArray[2] = -a6 * Constant.ROOT_2 / 48.0;
        dArray[3] = (1.0 - 2.0 * a6) / 8.0;
        dArray[4] = -a6 * Constant.ROOT_2 / 2.0;
        Polynomial a9 = new Polynomial(dArray);
        double[] dArray2 = new double[3];
        dArray2[0] = a6 * Constant.ROOT_2 * (20.0 * a6 - 1.0) / 960.0;
        dArray2[1] = (20.0 * a8 - 12.0 * a6 + 1.0) / 128.0;
        dArray2[2] = a6 * Constant.ROOT_2 * (3.0 * a6 - 2.0) / 12.0;
        Polynomial a10 = new Polynomial(dArray2);
        double[] dArray3 = new double[1];
        dArray3[0] = a6 * Constant.ROOT_2 * (-75.0 * a8 + 80.0 * a6 - 16.0) / 480.0;
        Polynomial a11 = new Polynomial(dArray3);
        double a12 = a9.evaluate(a7);
        double a13 = a10.evaluate(a7);
        double a14 = a11.evaluate(a7);
        double a15 = (a12 + (a13 + a14 / a2) / a2) / a2;
        double a16 = a7 + a15;
        double a17 = a16 * a16;
        return 0.5 * (1.0 + a16 * Math.sqrt((1.0 - Math.exp(-0.5 * a17)) / a17));
    }
}

